/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine.constraintvalidation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.constraints.Null;
import javax.validation.metadata.ConstraintDescriptor;
import org.hibernate.validator.internal.engine.constraintvalidation.ConstraintValidatorDescriptor;
import org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.TypeHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class ConstraintValidatorManager {
    private static final Log LOG = LoggerFactory.make();
    private static ConstraintValidator<?, ?> DUMMY_CONSTRAINT_VALIDATOR = new ConstraintValidator<Null, Object>(){

        public boolean isValid(Object value, ConstraintValidatorContext context) {
            return false;
        }
    };
    private final ConstraintValidatorFactory defaultConstraintValidatorFactory;
    private volatile ConstraintValidatorFactory mostRecentlyUsedNonDefaultConstraintValidatorFactory;
    private final Object mostRecentlyUsedNonDefaultConstraintValidatorFactoryMutex = new Object();
    private final ConcurrentHashMap<CacheKey, ConstraintValidator<?, ?>> constraintValidatorCache;

    public ConstraintValidatorManager(ConstraintValidatorFactory constraintValidatorFactory) {
        this.defaultConstraintValidatorFactory = constraintValidatorFactory;
        this.constraintValidatorCache = new ConcurrentHashMap();
    }

    public <A extends Annotation> ConstraintValidator<A, ?> getInitializedValidator(Type validatedValueType, ConstraintDescriptorImpl<A> descriptor, ConstraintValidatorFactory constraintFactory) {
        Contracts.assertNotNull(validatedValueType);
        Contracts.assertNotNull(descriptor);
        Contracts.assertNotNull(constraintFactory);
        CacheKey key = new CacheKey((Annotation)descriptor.getAnnotation(), validatedValueType, constraintFactory);
        Object constraintValidator = this.constraintValidatorCache.get(key);
        if (constraintValidator == null) {
            constraintValidator = this.createAndInitializeValidator(validatedValueType, descriptor, constraintFactory);
            constraintValidator = this.cacheValidator(key, (ConstraintValidator<A, ?>)constraintValidator);
        } else {
            LOG.tracef("Constraint validator %s found in cache.", constraintValidator);
        }
        return DUMMY_CONSTRAINT_VALIDATOR == constraintValidator ? null : constraintValidator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <A extends Annotation> ConstraintValidator<A, ?> cacheValidator(CacheKey key, ConstraintValidator<A, ?> constraintValidator) {
        ConstraintValidator<A, ?> cached;
        if (key.constraintFactory != this.defaultConstraintValidatorFactory && key.constraintFactory != this.mostRecentlyUsedNonDefaultConstraintValidatorFactory) {
            Object object = this.mostRecentlyUsedNonDefaultConstraintValidatorFactoryMutex;
            synchronized (object) {
                if (key.constraintFactory != this.mostRecentlyUsedNonDefaultConstraintValidatorFactory) {
                    this.clearEntriesForFactory(this.mostRecentlyUsedNonDefaultConstraintValidatorFactory);
                    this.mostRecentlyUsedNonDefaultConstraintValidatorFactory = key.constraintFactory;
                }
            }
        }
        return (cached = this.constraintValidatorCache.putIfAbsent(key, constraintValidator)) != null ? cached : constraintValidator;
    }

    private <A extends Annotation> ConstraintValidator<A, ?> createAndInitializeValidator(Type validatedValueType, ConstraintDescriptorImpl<A> descriptor, ConstraintValidatorFactory constraintFactory) {
        Object constraintValidator;
        ConstraintValidatorDescriptor<A> validatorDescriptor = this.findMatchingValidatorDescriptor(descriptor, validatedValueType);
        if (validatorDescriptor == null) {
            constraintValidator = DUMMY_CONSTRAINT_VALIDATOR;
        } else {
            constraintValidator = validatorDescriptor.newInstance(constraintFactory);
            this.initializeValidator((ConstraintDescriptor<A>)descriptor, (ConstraintValidator<A, ?>)constraintValidator);
        }
        return constraintValidator;
    }

    private void clearEntriesForFactory(ConstraintValidatorFactory constraintFactory) {
        Iterator<Map.Entry<CacheKey, ConstraintValidator<?, ?>>> cacheEntries = this.constraintValidatorCache.entrySet().iterator();
        while (cacheEntries.hasNext()) {
            Map.Entry<CacheKey, ConstraintValidator<?, ?>> cacheEntry = cacheEntries.next();
            if (cacheEntry.getKey().getConstraintFactory() != constraintFactory) continue;
            constraintFactory.releaseInstance(cacheEntry.getValue());
            cacheEntries.remove();
        }
    }

    public void clear() {
        for (Map.Entry<CacheKey, ConstraintValidator<?, ?>> entry : this.constraintValidatorCache.entrySet()) {
            entry.getKey().getConstraintFactory().releaseInstance(entry.getValue());
        }
        this.constraintValidatorCache.clear();
    }

    public ConstraintValidatorFactory getDefaultConstraintValidatorFactory() {
        return this.defaultConstraintValidatorFactory;
    }

    public int numberOfCachedConstraintValidatorInstances() {
        return this.constraintValidatorCache.size();
    }

    private <A extends Annotation> ConstraintValidatorDescriptor<A> findMatchingValidatorDescriptor(ConstraintDescriptorImpl<A> descriptor, Type validatedValueType) {
        Map<Type, ConstraintValidatorDescriptor<A>> availableValidatorDescriptors = TypeHelper.getValidatorTypes(descriptor.getAnnotationType(), descriptor.getMatchingConstraintValidatorDescriptors());
        List<Type> discoveredSuitableTypes = this.findSuitableValidatorTypes(validatedValueType, availableValidatorDescriptors.keySet());
        this.resolveAssignableTypes(discoveredSuitableTypes);
        if (discoveredSuitableTypes.size() == 0) {
            return null;
        }
        if (discoveredSuitableTypes.size() > 1) {
            throw LOG.getMoreThanOneValidatorFoundForTypeException(validatedValueType, discoveredSuitableTypes);
        }
        Type suitableType = discoveredSuitableTypes.get(0);
        return availableValidatorDescriptors.get(suitableType);
    }

    private <A extends Annotation> List<Type> findSuitableValidatorTypes(Type type, Iterable<Type> availableValidatorTypes) {
        ArrayList<Type> determinedSuitableTypes = CollectionHelper.newArrayList();
        for (Type validatorType : availableValidatorTypes) {
            if (!TypeHelper.isAssignable(validatorType, type) || determinedSuitableTypes.contains(validatorType)) continue;
            determinedSuitableTypes.add(validatorType);
        }
        return determinedSuitableTypes;
    }

    private <A extends Annotation> void initializeValidator(ConstraintDescriptor<A> descriptor, ConstraintValidator<A, ?> constraintValidator) {
        try {
            constraintValidator.initialize(descriptor.getAnnotation());
        }
        catch (RuntimeException e) {
            throw LOG.getUnableToInitializeConstraintValidatorException(constraintValidator.getClass(), e);
        }
    }

    private void resolveAssignableTypes(List<Type> assignableTypes) {
        if (assignableTypes.size() == 0 || assignableTypes.size() == 1) {
            return;
        }
        ArrayList<Type> typesToRemove = new ArrayList<Type>();
        do {
            typesToRemove.clear();
            Type type = assignableTypes.get(0);
            for (int i = 1; i < assignableTypes.size(); ++i) {
                if (TypeHelper.isAssignable(type, assignableTypes.get(i))) {
                    typesToRemove.add(type);
                    continue;
                }
                if (!TypeHelper.isAssignable(assignableTypes.get(i), type)) continue;
                typesToRemove.add(assignableTypes.get(i));
            }
            assignableTypes.removeAll(typesToRemove);
        } while (typesToRemove.size() > 0);
    }

    private static final class CacheKey {
        private final Annotation annotation;
        private final Type validatedType;
        private final ConstraintValidatorFactory constraintFactory;
        private final int hashCode;

        private CacheKey(Annotation annotation, Type validatorType, ConstraintValidatorFactory constraintFactory) {
            this.annotation = annotation;
            this.validatedType = validatorType;
            this.constraintFactory = constraintFactory;
            this.hashCode = this.createHashCode();
        }

        public ConstraintValidatorFactory getConstraintFactory() {
            return this.constraintFactory;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.annotation != null ? !this.annotation.equals(cacheKey.annotation) : cacheKey.annotation != null) {
                return false;
            }
            if (this.constraintFactory != null ? !this.constraintFactory.equals(cacheKey.constraintFactory) : cacheKey.constraintFactory != null) {
                return false;
            }
            return !(this.validatedType != null ? !this.validatedType.equals(cacheKey.validatedType) : cacheKey.validatedType != null);
        }

        public int hashCode() {
            return this.hashCode;
        }

        private int createHashCode() {
            int result = this.annotation != null ? this.annotation.hashCode() : 0;
            result = 31 * result + (this.validatedType != null ? this.validatedType.hashCode() : 0);
            result = 31 * result + (this.constraintFactory != null ? this.constraintFactory.hashCode() : 0);
            return result;
        }
    }
}

