/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.core;

import com.fasterxml.classmate.ResolvedType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.validation.metadata.ValidateUnwrappedValue;
import org.hibernate.validator.internal.engine.cascading.ValueExtractorDescriptor;
import org.hibernate.validator.internal.engine.cascading.ValueExtractorManager;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import org.hibernate.validator.internal.metadata.location.TypeArgumentConstraintLocation;
import org.hibernate.validator.internal.util.TypeHelper;
import org.hibernate.validator.internal.util.TypeResolutionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class MetaConstraints {
    private static final Log LOG = LoggerFactory.make();

    private MetaConstraints() {
    }

    public static <A extends Annotation> MetaConstraint<A> create(TypeResolutionHelper typeResolutionHelper, ValueExtractorManager valueExtractorManager, ConstraintDescriptorImpl<A> constraintDescriptor, ConstraintLocation location) {
        ArrayList<MetaConstraint.TypeParameterAndExtractor> valueExtractionPath = new ArrayList<MetaConstraint.TypeParameterAndExtractor>();
        Type typeOfValidatedElement = MetaConstraints.addValueExtractorDescriptorForWrappedValue(typeResolutionHelper, valueExtractorManager, constraintDescriptor, valueExtractionPath, location);
        ConstraintLocation current = location;
        do {
            if (current instanceof TypeArgumentConstraintLocation) {
                MetaConstraints.addValueExtractorDescriptorForTypeArgumentLocation(valueExtractorManager, valueExtractionPath, (TypeArgumentConstraintLocation)current);
                current = ((TypeArgumentConstraintLocation)current).getDelegate();
                continue;
            }
            current = null;
        } while (current != null);
        Collections.reverse(valueExtractionPath);
        return new MetaConstraint<A>(constraintDescriptor, location, valueExtractionPath, typeOfValidatedElement);
    }

    private static <A extends Annotation> Type addValueExtractorDescriptorForWrappedValue(TypeResolutionHelper typeResolutionHelper, ValueExtractorManager valueExtractorManager, ConstraintDescriptorImpl<A> constraintDescriptor, List<MetaConstraint.TypeParameterAndExtractor> valueExtractionPath, ConstraintLocation location) {
        if (ValidateUnwrappedValue.NO.equals((Object)constraintDescriptor.validateUnwrappedValue())) {
            return location.getTypeForValidatorResolution();
        }
        Class<?> declaredType = TypeHelper.getErasedReferenceType(location.getTypeForValidatorResolution());
        ValueExtractorDescriptor valueExtractorDescriptorCandidate = valueExtractorManager.getValueExtractor(declaredType);
        if (ValidateUnwrappedValue.DEFAULT.equals((Object)constraintDescriptor.validateUnwrappedValue()) && (valueExtractorDescriptorCandidate == null || !valueExtractorDescriptorCandidate.isUnwrapByDefault())) {
            return location.getTypeForValidatorResolution();
        }
        if (valueExtractorDescriptorCandidate == null) {
            throw LOG.getNoValueExtractorFoundForTypeException(declaredType, null);
        }
        valueExtractionPath.add(MetaConstraint.TypeParameterAndExtractor.of(valueExtractorDescriptorCandidate));
        return MetaConstraints.getSingleTypeParameterBind(typeResolutionHelper, location.getTypeForValidatorResolution(), valueExtractorDescriptorCandidate.getExtractedType());
    }

    private static void addValueExtractorDescriptorForTypeArgumentLocation(ValueExtractorManager valueExtractorManager, List<MetaConstraint.TypeParameterAndExtractor> valueExtractionPath, TypeArgumentConstraintLocation typeArgumentConstraintLocation) {
        TypeVariable<?> typeParameter;
        Class<?> declaredType = TypeHelper.getErasedReferenceType(typeArgumentConstraintLocation.getContainerType());
        ValueExtractorDescriptor valueExtractorDescriptor = valueExtractorManager.getValueExtractor(declaredType, typeParameter = typeArgumentConstraintLocation.getTypeParameter());
        if (valueExtractorDescriptor == null) {
            throw LOG.getNoValueExtractorFoundForTypeException(declaredType, typeParameter);
        }
        valueExtractionPath.add(MetaConstraint.TypeParameterAndExtractor.of(typeParameter, valueExtractorDescriptor));
    }

    static Class<?> getSingleTypeParameterBind(TypeResolutionHelper typeResolutionHelper, Type subType, Class<?> superType) {
        ResolvedType resolvedType = typeResolutionHelper.getTypeResolver().resolve(subType, new Type[0]);
        List resolvedTypeParameters = resolvedType.typeParametersFor(superType);
        if (resolvedTypeParameters.isEmpty()) {
            throw LOG.getNoValueExtractorFoundForUnwrapException(subType);
        }
        if (resolvedTypeParameters.size() > 1) {
            throw LOG.getUnableToExtractValueForTypeWithMultipleTypeParametersException(subType);
        }
        return ((ResolvedType)resolvedTypeParameters.iterator().next()).getErasedType();
    }
}

