/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.core;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.validation.valueextraction.ValueExtractor;
import org.hibernate.validator.internal.engine.ValidationContext;
import org.hibernate.validator.internal.engine.ValueContext;
import org.hibernate.validator.internal.engine.cascading.ValueExtractorDescriptor;
import org.hibernate.validator.internal.engine.constraintvalidation.ConstraintTree;
import org.hibernate.validator.internal.engine.path.PathImpl;
import org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import org.hibernate.validator.internal.util.StringHelper;

public class MetaConstraint<A extends Annotation> {
    private final ConstraintTree<A> constraintTree;
    private final ConstraintLocation location;
    private final ValueExtractionPathNode valueExtractionPath;
    private final int hashCode;

    MetaConstraint(ConstraintDescriptorImpl<A> constraintDescriptor, ConstraintLocation location, List<TypeParameterAndExtractor> valueExtractionPath, Type validatedValueType) {
        this.constraintTree = new ConstraintTree<A>(constraintDescriptor, validatedValueType);
        this.location = location;
        this.valueExtractionPath = MetaConstraint.getValueExtractionPath(valueExtractionPath);
        this.hashCode = MetaConstraint.buildHashCode(constraintDescriptor, location);
    }

    private static ValueExtractionPathNode getValueExtractionPath(List<TypeParameterAndExtractor> valueExtractionPath) {
        switch (valueExtractionPath.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return new SingleValueExtractionPathNode(valueExtractionPath.iterator().next());
            }
        }
        return new LinkedValueExtractionPathNode(null, valueExtractionPath);
    }

    public final Set<Class<?>> getGroupList() {
        return this.constraintTree.getDescriptor().getGroups();
    }

    public final ConstraintDescriptorImpl<A> getDescriptor() {
        return this.constraintTree.getDescriptor();
    }

    public final ElementType getElementType() {
        return this.constraintTree.getDescriptor().getElementType();
    }

    public boolean validateConstraint(ValidationContext<?> validationContext, ValueContext<?, Object> valueContext) {
        boolean success = true;
        if (this.valueExtractionPath != null) {
            Object valueToValidate = valueContext.getCurrentValidatedValue();
            if (valueToValidate != null) {
                TypeParameterValueReceiver receiver = new TypeParameterValueReceiver(validationContext, valueContext, this.valueExtractionPath);
                this.valueExtractionPath.getValueExtractorDescriptor().getValueExtractor().extractValues(valueToValidate, (ValueExtractor.ValueReceiver)receiver);
                success = receiver.isSuccess();
            }
        } else {
            success = this.doValidateConstraint(validationContext, valueContext);
        }
        return success;
    }

    private boolean doValidateConstraint(ValidationContext<?> executionContext, ValueContext<?, ?> valueContext) {
        valueContext.setElementType(this.getElementType());
        boolean validationResult = this.constraintTree.validateConstraints(executionContext, valueContext);
        return validationResult;
    }

    public ConstraintLocation getLocation() {
        return this.location;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetaConstraint that = (MetaConstraint)o;
        if (!this.constraintTree.getDescriptor().equals(that.constraintTree.getDescriptor())) {
            return false;
        }
        return this.location.equals(that.location);
    }

    private static int buildHashCode(ConstraintDescriptorImpl<?> constraintDescriptor, ConstraintLocation location) {
        int prime = 31;
        int result = 1;
        result = 31 * result + constraintDescriptor.hashCode();
        result = 31 * result + location.hashCode();
        return result;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MetaConstraint");
        sb.append("{constraintType=").append(StringHelper.toShortString(this.constraintTree.getDescriptor().getAnnotation().annotationType()));
        sb.append(", location=").append(this.location);
        sb.append(", valueExtractionPath=").append(this.valueExtractionPath);
        sb.append("}");
        return sb.toString();
    }

    private static final class LinkedValueExtractionPathNode
    implements ValueExtractionPathNode {
        private final ValueExtractionPathNode previous;
        private final ValueExtractionPathNode next;
        private final TypeVariable<?> typeParameter;
        private final ValueExtractorDescriptor valueExtractorDescriptor;

        private LinkedValueExtractionPathNode(ValueExtractionPathNode previous, List<TypeParameterAndExtractor> elements) {
            TypeParameterAndExtractor first = elements.get(0);
            this.typeParameter = first.typeParameter;
            this.valueExtractorDescriptor = first.valueExtractorDescriptor;
            this.previous = previous;
            this.next = elements.size() == 1 ? null : new LinkedValueExtractionPathNode(this, elements.subList(1, elements.size()));
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public ValueExtractionPathNode getPrevious() {
            return this.previous;
        }

        @Override
        public ValueExtractionPathNode getNext() {
            return this.next;
        }

        @Override
        public TypeVariable<?> getTypeParameter() {
            return this.typeParameter;
        }

        @Override
        public ValueExtractorDescriptor getValueExtractorDescriptor() {
            return this.valueExtractorDescriptor;
        }

        public String toString() {
            return "LinkedValueExtractionPathNode [typeParameter=" + this.typeParameter + ", valueExtractorDescriptor=" + this.valueExtractorDescriptor + "]";
        }
    }

    private static final class SingleValueExtractionPathNode
    implements ValueExtractionPathNode {
        private final TypeVariable<?> typeParameter;
        private final ValueExtractorDescriptor valueExtractorDescriptor;

        public SingleValueExtractionPathNode(TypeParameterAndExtractor typeParameterAndExtractor) {
            this.typeParameter = typeParameterAndExtractor.typeParameter;
            this.valueExtractorDescriptor = typeParameterAndExtractor.valueExtractorDescriptor;
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public ValueExtractionPathNode getPrevious() {
            throw new NoSuchElementException();
        }

        @Override
        public ValueExtractionPathNode getNext() {
            throw new NoSuchElementException();
        }

        @Override
        public TypeVariable<?> getTypeParameter() {
            return this.typeParameter;
        }

        @Override
        public ValueExtractorDescriptor getValueExtractorDescriptor() {
            return this.valueExtractorDescriptor;
        }
    }

    private static interface ValueExtractionPathNode {
        public boolean hasNext();

        public ValueExtractionPathNode getPrevious();

        public ValueExtractionPathNode getNext();

        public TypeVariable<?> getTypeParameter();

        public ValueExtractorDescriptor getValueExtractorDescriptor();
    }

    static final class TypeParameterAndExtractor {
        private final TypeVariable<?> typeParameter;
        private final ValueExtractorDescriptor valueExtractorDescriptor;

        private TypeParameterAndExtractor(TypeVariable<?> typeParameter, ValueExtractorDescriptor valueExtractorDescriptor) {
            this.typeParameter = typeParameter;
            this.valueExtractorDescriptor = valueExtractorDescriptor;
        }

        static TypeParameterAndExtractor of(ValueExtractorDescriptor valueExtractorDescriptor) {
            return new TypeParameterAndExtractor(null, valueExtractorDescriptor);
        }

        static TypeParameterAndExtractor of(TypeVariable<?> typeParameter, ValueExtractorDescriptor valueExtractorDescriptor) {
            return new TypeParameterAndExtractor(typeParameter, valueExtractorDescriptor);
        }

        public String toString() {
            return "TypeParameterAndExtractor [typeParameter=" + this.typeParameter + ", valueExtractorDescriptor=" + this.valueExtractorDescriptor + "]";
        }
    }

    private final class TypeParameterValueReceiver
    implements ValueExtractor.ValueReceiver {
        private final ValidationContext<?> validationContext;
        private final ValueContext<?, Object> valueContext;
        private boolean success = true;
        private ValueExtractionPathNode currentValueExtractionPathNode;

        public TypeParameterValueReceiver(ValidationContext<?> validationContext, ValueContext<?, Object> valueContext, ValueExtractionPathNode currentValueExtractionPathNode) {
            this.validationContext = validationContext;
            this.valueContext = valueContext;
            this.currentValueExtractionPathNode = currentValueExtractionPathNode;
        }

        public void value(String nodeName, Object object) {
            this.doValidate(object, nodeName);
        }

        public void iterableValue(String nodeName, Object value) {
            this.valueContext.markCurrentPropertyAsIterable();
            this.doValidate(value, nodeName);
        }

        public void indexedValue(String nodeName, int index, Object value) {
            this.valueContext.markCurrentPropertyAsIterable();
            this.valueContext.setIndex(index);
            this.doValidate(value, nodeName);
        }

        public void keyedValue(String nodeName, Object key, Object value) {
            this.valueContext.markCurrentPropertyAsIterable();
            this.valueContext.setKey(key);
            this.doValidate(value, nodeName);
        }

        private void doValidate(Object value, String nodeName) {
            PathImpl before = this.valueContext.getPropertyPath();
            TypeVariable<?> typeParameter = this.currentValueExtractionPathNode.getTypeParameter();
            if (typeParameter != null) {
                this.valueContext.setTypeParameter(typeParameter);
            }
            if (nodeName != null) {
                this.valueContext.appendTypeParameterNode(nodeName);
            }
            if (this.currentValueExtractionPathNode.hasNext()) {
                if (value != null) {
                    this.currentValueExtractionPathNode = this.currentValueExtractionPathNode.getNext();
                    ValueExtractorDescriptor valueExtractorDescriptor = this.currentValueExtractionPathNode.getValueExtractorDescriptor();
                    valueExtractorDescriptor.getValueExtractor().extractValues(value, (ValueExtractor.ValueReceiver)this);
                    this.currentValueExtractionPathNode = this.currentValueExtractionPathNode.getPrevious();
                }
            } else {
                this.valueContext.setCurrentValidatedValue(value);
                this.success &= MetaConstraint.this.doValidateConstraint(this.validationContext, this.valueContext);
            }
            this.valueContext.setPropertyPath(before);
        }

        public boolean isSuccess() {
            return this.success;
        }
    }
}

