/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.aggregated;

import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.hibernate.validator.internal.engine.path.PathImpl;
import org.hibernate.validator.internal.metadata.aggregated.CascadingMetaData;
import org.hibernate.validator.internal.metadata.cascading.CascadingTypeParameter;
import org.hibernate.validator.internal.metadata.facets.Cascadable;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.privilegedactions.GetDeclaredField;
import org.hibernate.validator.internal.util.privilegedactions.SetAccessibility;

public class FieldCascadable
implements Cascadable {
    private final Field field;
    private final String propertyName;
    private final Type cascadableType;
    private final CascadingMetaData cascadingMetaData;

    FieldCascadable(Field field, CascadingMetaData cascadingMetaData) {
        this.field = field;
        this.propertyName = field.getName();
        this.cascadableType = ReflectionHelper.typeOf(field);
        this.cascadingMetaData = cascadingMetaData;
        this.cascadingMetaData.validateGroupConversions(field.toString());
    }

    @Override
    public ElementType getElementType() {
        return ElementType.FIELD;
    }

    @Override
    public Type getCascadableType() {
        return this.cascadableType;
    }

    @Override
    public Object getValue(Object parent) {
        return ReflectionHelper.getValue(this.field, parent);
    }

    @Override
    public void appendTo(PathImpl path) {
        path.addPropertyNode(this.propertyName);
    }

    @Override
    public CascadingMetaData getCascadingMetaData() {
        return this.cascadingMetaData;
    }

    public static class Builder
    implements Cascadable.Builder {
        private final Field field;
        private CascadingTypeParameter cascadingMetaData;

        public Builder(Field field, CascadingTypeParameter cascadingMetaData) {
            this.field = field;
            this.cascadingMetaData = cascadingMetaData;
        }

        @Override
        public void mergeCascadingMetaData(CascadingTypeParameter cascadingMetaData) {
            this.cascadingMetaData = this.cascadingMetaData.merge(cascadingMetaData);
        }

        @Override
        public FieldCascadable build() {
            return new FieldCascadable(this.getAccessible(this.field), new CascadingMetaData(this.cascadingMetaData));
        }

        private Field getAccessible(Field original) {
            if (original.isAccessible()) {
                return original;
            }
            Class<?> clazz = original.getDeclaringClass();
            Field member = this.run(GetDeclaredField.action(clazz, original.getName()));
            this.run(SetAccessibility.action(member));
            return member;
        }

        private <T> T run(PrivilegedAction<T> action) {
            return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
        }
    }
}

