/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.aggregated;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.ElementKind;
import javax.validation.metadata.ContainerElementTypeDescriptor;
import javax.validation.metadata.GroupConversionDescriptor;
import org.hibernate.validator.internal.metadata.aggregated.CascadingMetaData;
import org.hibernate.validator.internal.metadata.aggregated.ConstraintMetaData;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;
import org.hibernate.validator.internal.metadata.descriptor.ContainerElementTypeDescriptorImpl;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import org.hibernate.validator.internal.metadata.location.TypeArgumentConstraintLocation;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.TypeVariables;

public abstract class AbstractConstraintMetaData
implements ConstraintMetaData {
    private final String name;
    private final Type type;
    private final ElementKind constrainedMetaDataKind;
    private final Set<MetaConstraint<?>> directConstraints;
    private final Set<MetaConstraint<?>> containerElementsConstraints;
    private final Set<MetaConstraint<?>> allConstraints;
    private final boolean isCascading;
    private final boolean isConstrained;

    public AbstractConstraintMetaData(String name, Type type, Set<MetaConstraint<?>> directConstraints, Set<MetaConstraint<?>> containerElementsConstraints, ElementKind constrainedMetaDataKind, boolean isCascading, boolean isConstrained) {
        this.name = name;
        this.type = type;
        this.directConstraints = CollectionHelper.toImmutableSet(directConstraints);
        this.containerElementsConstraints = CollectionHelper.toImmutableSet(containerElementsConstraints);
        this.allConstraints = Stream.concat(directConstraints.stream(), containerElementsConstraints.stream()).collect(Collectors.collectingAndThen(Collectors.toSet(), CollectionHelper::toImmutableSet));
        this.constrainedMetaDataKind = constrainedMetaDataKind;
        this.isCascading = isCascading;
        this.isConstrained = isConstrained;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public Iterator<MetaConstraint<?>> iterator() {
        return this.allConstraints.iterator();
    }

    public Set<MetaConstraint<?>> getAllConstraints() {
        return this.allConstraints;
    }

    public Set<MetaConstraint<?>> getDirectConstraints() {
        return this.directConstraints;
    }

    public Set<MetaConstraint<?>> getContainerElementsConstraints() {
        return this.containerElementsConstraints;
    }

    @Override
    public ElementKind getKind() {
        return this.constrainedMetaDataKind;
    }

    @Override
    public final boolean isCascading() {
        return this.isCascading;
    }

    @Override
    public boolean isConstrained() {
        return this.isConstrained;
    }

    public String toString() {
        return "AbstractConstraintMetaData [name=" + this.name + ", type=" + this.type + ", constrainedMetaDataKind=" + this.constrainedMetaDataKind + ", directConstraints=" + this.directConstraints + ", containerElementsConstraints=" + this.containerElementsConstraints + ", isCascading=" + this.isCascading + ", isConstrained=" + this.isConstrained + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractConstraintMetaData other = (AbstractConstraintMetaData)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    protected Set<ConstraintDescriptorImpl<?>> asDescriptors(Set<MetaConstraint<?>> constraints) {
        HashSet<ConstraintDescriptorImpl<?>> theValue = CollectionHelper.newHashSet();
        for (MetaConstraint<?> oneConstraint : constraints) {
            theValue.add(oneConstraint.getDescriptor());
        }
        return theValue;
    }

    protected List<ContainerElementTypeDescriptor> asContainerElementTypeDescriptors(Set<MetaConstraint<?>> containerElementsConstraints, CascadingMetaData cascadingMetaData, boolean defaultGroupSequenceRedefined, List<Class<?>> defaultGroupSequence) {
        return this.asContainerElementTypeDescriptors(this.type, ContainerElementMetaConstraintTree.of(containerElementsConstraints), cascadingMetaData, defaultGroupSequenceRedefined, defaultGroupSequence);
    }

    private List<ContainerElementTypeDescriptor> asContainerElementTypeDescriptors(Type type, ContainerElementMetaConstraintTree containerElementMetaConstraintTree, CascadingMetaData cascadingMetaData, boolean defaultGroupSequenceRedefined, List<Class<?>> defaultGroupSequence) {
        if (type instanceof ParameterizedType) {
            ArrayList<ContainerElementTypeDescriptor> containerElementTypeDescriptors = new ArrayList<ContainerElementTypeDescriptor>();
            Type[] typeArguments = ((ParameterizedType)type).getActualTypeArguments();
            TypeVariable<Class<?>>[] typeParameters = ReflectionHelper.getClassFromType(type).getTypeParameters();
            for (int i = 0; i < typeArguments.length; ++i) {
                Type typeArgument = typeArguments[i];
                TypeVariable<Class<?>> typeParameter = typeParameters[i];
                Set constraints = Collections.emptySet();
                ContainerElementMetaConstraintTree currentContainerElementMetaConstraintTree = null;
                if (containerElementMetaConstraintTree != null && containerElementMetaConstraintTree.nodes.containsKey(typeParameter)) {
                    currentContainerElementMetaConstraintTree = (ContainerElementMetaConstraintTree)containerElementMetaConstraintTree.nodes.get(typeParameter);
                    constraints = ((ContainerElementMetaConstraintTree)containerElementMetaConstraintTree.nodes.get(typeParameter)).constraints;
                }
                CascadingMetaData currentCascadingMetaData = null;
                boolean cascading = false;
                Set<GroupConversionDescriptor> groupConversionDescriptors = Collections.emptySet();
                if (cascadingMetaData != null) {
                    for (CascadingMetaData candidateCascadingMetaData : cascadingMetaData.getContainerElementTypesCascadingMetaData()) {
                        if (!candidateCascadingMetaData.getTypeParameter().equals(typeParameter)) continue;
                        currentCascadingMetaData = candidateCascadingMetaData;
                        cascading = currentCascadingMetaData.isCascading();
                        groupConversionDescriptors = currentCascadingMetaData.getGroupConversionDescriptors();
                    }
                }
                containerElementTypeDescriptors.add(new ContainerElementTypeDescriptorImpl(typeArgument, TypeVariables.getTypeParameterIndex(typeParameter), this.asDescriptors(constraints), this.asContainerElementTypeDescriptors(typeArgument, currentContainerElementMetaConstraintTree, currentCascadingMetaData, defaultGroupSequenceRedefined, defaultGroupSequence), cascading, defaultGroupSequenceRedefined, defaultGroupSequence, groupConversionDescriptors));
            }
            return containerElementTypeDescriptors;
        }
        if (type instanceof GenericArrayType) {
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    private static class ContainerElementMetaConstraintTree {
        private Map<TypeVariable<?>, ContainerElementMetaConstraintTree> nodes = new HashMap();
        private Set<MetaConstraint<?>> constraints = new HashSet();

        private ContainerElementMetaConstraintTree() {
        }

        private static ContainerElementMetaConstraintTree of(Set<MetaConstraint<?>> containerElementsConstraints) {
            ContainerElementMetaConstraintTree containerElementMetaConstraintTree = new ContainerElementMetaConstraintTree();
            for (MetaConstraint<?> constraint : containerElementsConstraints) {
                ConstraintLocation currentLocation = constraint.getLocation();
                ArrayList constraintPath = new ArrayList();
                while (currentLocation instanceof TypeArgumentConstraintLocation) {
                    TypeArgumentConstraintLocation typeArgumentConstraintLocation = (TypeArgumentConstraintLocation)currentLocation;
                    constraintPath.add(typeArgumentConstraintLocation.getTypeParameter());
                    currentLocation = typeArgumentConstraintLocation.getDelegate();
                }
                Collections.reverse(constraintPath);
                containerElementMetaConstraintTree.addConstraint(constraintPath, constraint);
            }
            return containerElementMetaConstraintTree;
        }

        private void addConstraint(List<TypeVariable<?>> path, MetaConstraint<?> constraint) {
            ContainerElementMetaConstraintTree tree = this;
            for (TypeVariable<?> typeParameter : path) {
                tree = tree.nodes.computeIfAbsent(typeParameter, tp -> new ContainerElementMetaConstraintTree());
            }
            tree.constraints.add(constraint);
        }
    }
}

