/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine.cascading;

import java.lang.reflect.TypeVariable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import javax.validation.valueextraction.ValueExtractor;
import org.hibernate.validator.internal.engine.cascading.BooleanArrayValueExtractor;
import org.hibernate.validator.internal.engine.cascading.ByteArrayValueExtractor;
import org.hibernate.validator.internal.engine.cascading.CharArrayValueExtractor;
import org.hibernate.validator.internal.engine.cascading.DoubleArrayValueExtractor;
import org.hibernate.validator.internal.engine.cascading.FloatArrayValueExtractor;
import org.hibernate.validator.internal.engine.cascading.IntArrayValueExtractor;
import org.hibernate.validator.internal.engine.cascading.IterableValueExtractor;
import org.hibernate.validator.internal.engine.cascading.LegacyIterableValueExtractor;
import org.hibernate.validator.internal.engine.cascading.LegacyListValueExtractor;
import org.hibernate.validator.internal.engine.cascading.LegacyMapValueExtractor;
import org.hibernate.validator.internal.engine.cascading.LegacyOptionalValueExtractor;
import org.hibernate.validator.internal.engine.cascading.ListPropertyValueExtractor;
import org.hibernate.validator.internal.engine.cascading.ListValueExtractor;
import org.hibernate.validator.internal.engine.cascading.LongArrayValueExtractor;
import org.hibernate.validator.internal.engine.cascading.MapKeyExtractor;
import org.hibernate.validator.internal.engine.cascading.MapPropertyKeyExtractor;
import org.hibernate.validator.internal.engine.cascading.MapPropertyValueExtractor;
import org.hibernate.validator.internal.engine.cascading.MapValueExtractor;
import org.hibernate.validator.internal.engine.cascading.ObjectArrayValueExtractor;
import org.hibernate.validator.internal.engine.cascading.ObjectValueExtractor;
import org.hibernate.validator.internal.engine.cascading.ObservableValueValueExtractor;
import org.hibernate.validator.internal.engine.cascading.OptionalValueExtractor;
import org.hibernate.validator.internal.engine.cascading.ReadOnlyListPropertyValueExtractor;
import org.hibernate.validator.internal.engine.cascading.ReadOnlyMapPropertyKeyExtractor;
import org.hibernate.validator.internal.engine.cascading.ReadOnlyMapPropertyValueExtractor;
import org.hibernate.validator.internal.engine.cascading.ReadOnlySetPropertyValueExtractor;
import org.hibernate.validator.internal.engine.cascading.SetPropertyValueExtractor;
import org.hibernate.validator.internal.engine.cascading.ShortArrayValueExtractor;
import org.hibernate.validator.internal.engine.cascading.ValueExtractorDescriptor;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.TypeHelper;
import org.hibernate.validator.internal.util.TypeVariableBindings;
import org.hibernate.validator.internal.util.TypeVariables;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.util.privilegedactions.LoadClass;

public class ValueExtractorManager {
    private static final Log LOG = LoggerFactory.make();
    public static final Set<ValueExtractorDescriptor> SPEC_DEFINED_EXTRACTORS;
    private final Map<ValueExtractorDescriptor.Key, ValueExtractorDescriptor> valueExtractors;

    public ValueExtractorManager(Set<ValueExtractor<?>> externalExtractors) {
        LinkedHashMap<ValueExtractorDescriptor.Key, ValueExtractorDescriptor> tmpValueExtractors = new LinkedHashMap<ValueExtractorDescriptor.Key, ValueExtractorDescriptor>();
        for (ValueExtractorDescriptor valueExtractorDescriptor : SPEC_DEFINED_EXTRACTORS) {
            tmpValueExtractors.put(valueExtractorDescriptor.getKey(), valueExtractorDescriptor);
        }
        tmpValueExtractors.put(LegacyOptionalValueExtractor.DESCRIPTOR.getKey(), LegacyOptionalValueExtractor.DESCRIPTOR);
        for (ValueExtractor valueExtractor : externalExtractors) {
            ValueExtractorDescriptor descriptor = new ValueExtractorDescriptor(valueExtractor);
            tmpValueExtractors.put(descriptor.getKey(), descriptor);
        }
        this.valueExtractors = Collections.unmodifiableMap(tmpValueExtractors);
    }

    public ValueExtractorManager(ValueExtractorManager template, Map<ValueExtractorDescriptor.Key, ValueExtractorDescriptor> externalValueExtractorDescriptors) {
        LinkedHashMap<ValueExtractorDescriptor.Key, ValueExtractorDescriptor> tmpValueExtractors = new LinkedHashMap<ValueExtractorDescriptor.Key, ValueExtractorDescriptor>(template.valueExtractors);
        tmpValueExtractors.putAll(externalValueExtractorDescriptors);
        this.valueExtractors = Collections.unmodifiableMap(tmpValueExtractors);
    }

    public static Set<ValueExtractor<?>> getDefaultValueExtractors() {
        return SPEC_DEFINED_EXTRACTORS.stream().map(d -> d.getValueExtractor()).collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
    }

    public ValueExtractorDescriptor getValueExtractor(Class<?> valueType) {
        List<ValueExtractorDescriptor> typeCompatibleExtractors = this.valueExtractors.values().stream().filter(e -> TypeHelper.isAssignable(TypeHelper.getErasedReferenceType(e.getExtractedType()), valueType)).collect(Collectors.toList());
        return this.getMostSpecific(valueType, typeCompatibleExtractors);
    }

    public ValueExtractorDescriptor getValueExtractor(Class<?> valueType, TypeVariable<?> typeParameter) {
        boolean isInternal = TypeVariables.isInternal(typeParameter);
        Map<Class<?>, Map<TypeVariable<?>, TypeVariable<?>>> allBindings = null;
        if (!isInternal) {
            allBindings = TypeVariableBindings.getTypeVariableBindings((Class)typeParameter.getGenericDeclaration());
        }
        List typeCompatibleExtractors = this.valueExtractors.values().stream().filter(e -> TypeHelper.isAssignable(e.getExtractedType(), valueType)).collect(Collectors.toList());
        ArrayList<ValueExtractorDescriptor> typeParameterCompatibleExtractors = new ArrayList<ValueExtractorDescriptor>();
        for (ValueExtractorDescriptor extractorDescriptor : typeCompatibleExtractors) {
            TypeVariable<?> typeParameterBoundToExtractorType;
            if (!isInternal) {
                Map<TypeVariable<?>, TypeVariable<?>> bindingsForExtractorType = allBindings.get(extractorDescriptor.getExtractedType());
                typeParameterBoundToExtractorType = this.bind(typeParameter, bindingsForExtractorType);
            } else {
                typeParameterBoundToExtractorType = typeParameter;
            }
            if (!Objects.equals(extractorDescriptor.getExtractedTypeParameter(), typeParameterBoundToExtractorType)) continue;
            typeParameterCompatibleExtractors.add(extractorDescriptor);
        }
        return this.getMostSpecific(valueType, typeParameterCompatibleExtractors);
    }

    private ValueExtractorDescriptor getMostSpecific(Class<?> valueType, List<ValueExtractorDescriptor> extractors) {
        HashSet candidates = CollectionHelper.newHashSet(extractors.size());
        for (ValueExtractorDescriptor descriptor : extractors) {
            if (candidates.isEmpty()) {
                candidates.add(descriptor);
                continue;
            }
            Iterator candidatesIterator = candidates.iterator();
            boolean isNewRoot = true;
            while (candidatesIterator.hasNext()) {
                ValueExtractorDescriptor candidate = (ValueExtractorDescriptor)candidatesIterator.next();
                if (TypeHelper.isAssignable(candidate.getExtractedType(), descriptor.getExtractedType())) {
                    candidatesIterator.remove();
                    continue;
                }
                if (!TypeHelper.isAssignable(descriptor.getExtractedType(), candidate.getExtractedType())) continue;
                isNewRoot = false;
            }
            if (!isNewRoot) continue;
            candidates.add(descriptor);
        }
        if (candidates.isEmpty()) {
            return null;
        }
        if (candidates.size() == 1) {
            return (ValueExtractorDescriptor)candidates.iterator().next();
        }
        List<Class<? extends ValueExtractor>> valueExtractorCandidates = candidates.stream().map(valueExtractorDescriptor -> valueExtractorDescriptor.getValueExtractor().getClass()).collect(Collectors.toList());
        throw LOG.unableToGetMostSpecificValueExtractorDueToSeveralValueExtractorsDefinedForParallelHierarchies(valueType, valueExtractorCandidates);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.valueExtractors == null ? 0 : this.valueExtractors.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValueExtractorManager other = (ValueExtractorManager)obj;
        return this.valueExtractors.equals(other.valueExtractors);
    }

    private TypeVariable<?> bind(TypeVariable<?> typeParameter, Map<TypeVariable<?>, TypeVariable<?>> bindings) {
        return bindings != null ? bindings.get(typeParameter) : null;
    }

    private static boolean isJavaFxInClasspath() {
        return ValueExtractorManager.isClassPresent("javafx.application.Application", false);
    }

    private static boolean isClassPresent(String className, boolean fallbackOnTCCL) {
        try {
            ValueExtractorManager.run(LoadClass.action(className, ValueExtractorManager.class.getClassLoader(), fallbackOnTCCL));
            return true;
        }
        catch (ValidationException e) {
            return false;
        }
    }

    private static <T> T run(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }

    static {
        LinkedHashSet<ValueExtractorDescriptor> specDefinedExtractors = new LinkedHashSet<ValueExtractorDescriptor>();
        if (ValueExtractorManager.isJavaFxInClasspath()) {
            specDefinedExtractors.add(ObservableValueValueExtractor.DESCRIPTOR);
            specDefinedExtractors.add(ListPropertyValueExtractor.DESCRIPTOR);
            specDefinedExtractors.add(ReadOnlyListPropertyValueExtractor.DESCRIPTOR);
            specDefinedExtractors.add(MapPropertyValueExtractor.DESCRIPTOR);
            specDefinedExtractors.add(ReadOnlyMapPropertyValueExtractor.DESCRIPTOR);
            specDefinedExtractors.add(MapPropertyKeyExtractor.DESCRIPTOR);
            specDefinedExtractors.add(ReadOnlyMapPropertyKeyExtractor.DESCRIPTOR);
            specDefinedExtractors.add(SetPropertyValueExtractor.DESCRIPTOR);
            specDefinedExtractors.add(ReadOnlySetPropertyValueExtractor.DESCRIPTOR);
        }
        specDefinedExtractors.add(ByteArrayValueExtractor.DESCRIPTOR);
        specDefinedExtractors.add(ShortArrayValueExtractor.DESCRIPTOR);
        specDefinedExtractors.add(IntArrayValueExtractor.DESCRIPTOR);
        specDefinedExtractors.add(LongArrayValueExtractor.DESCRIPTOR);
        specDefinedExtractors.add(FloatArrayValueExtractor.DESCRIPTOR);
        specDefinedExtractors.add(DoubleArrayValueExtractor.DESCRIPTOR);
        specDefinedExtractors.add(CharArrayValueExtractor.DESCRIPTOR);
        specDefinedExtractors.add(BooleanArrayValueExtractor.DESCRIPTOR);
        specDefinedExtractors.add(ObjectArrayValueExtractor.DESCRIPTOR);
        specDefinedExtractors.add(LegacyListValueExtractor.DESCRIPTOR);
        specDefinedExtractors.add(ListValueExtractor.DESCRIPTOR);
        specDefinedExtractors.add(LegacyMapValueExtractor.DESCRIPTOR);
        specDefinedExtractors.add(MapValueExtractor.DESCRIPTOR);
        specDefinedExtractors.add(MapKeyExtractor.DESCRIPTOR);
        specDefinedExtractors.add(LegacyIterableValueExtractor.DESCRIPTOR);
        specDefinedExtractors.add(IterableValueExtractor.DESCRIPTOR);
        specDefinedExtractors.add(OptionalValueExtractor.DESCRIPTOR);
        specDefinedExtractors.add(ObjectValueExtractor.DESCRIPTOR);
        SPEC_DEFINED_EXTRACTORS = Collections.unmodifiableSet(specDefinedExtractors);
    }
}

