/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine.cascading;

import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.valueextraction.ExtractedValue;
import javax.validation.valueextraction.UnwrapByDefault;
import javax.validation.valueextraction.ValueExtractor;
import org.hibernate.validator.internal.engine.cascading.AnnotatedObject;
import org.hibernate.validator.internal.engine.cascading.ArrayElement;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.StringHelper;
import org.hibernate.validator.internal.util.TypeHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class ValueExtractorDescriptor {
    private static final Log LOG = LoggerFactory.make();
    private final Key key;
    private final ValueExtractor<?> valueExtractor;
    private final boolean unwrapByDefault;

    public ValueExtractorDescriptor(ValueExtractor<?> valueExtractor) {
        this.key = new Key(ValueExtractorDescriptor.getExtractedType(valueExtractor.getClass()), ValueExtractorDescriptor.getExtractedTypeParameter(valueExtractor.getClass()));
        this.valueExtractor = valueExtractor;
        this.unwrapByDefault = ValueExtractorDescriptor.hasUnwrapByDefaultAnnotation(valueExtractor.getClass());
    }

    private static TypeVariable<?> getExtractedTypeParameter(Class<? extends ValueExtractor> extractorImplementationType) {
        AnnotatedParameterizedType valueExtractorDefinition = ValueExtractorDescriptor.getValueExtractorDefinition(extractorImplementationType);
        AnnotatedType extractedType = valueExtractorDefinition.getAnnotatedActualTypeArguments()[0];
        Class extractedTypeRaw = (Class)TypeHelper.getErasedType(extractedType.getType());
        TypeVariable<Class<Object>> extractedTypeParameter = null;
        if (extractedType.isAnnotationPresent(ExtractedValue.class)) {
            extractedTypeParameter = extractedType instanceof AnnotatedArrayType ? new ArrayElement((AnnotatedArrayType)extractedType) : AnnotatedObject.INSTANCE;
        }
        if (extractedType instanceof AnnotatedParameterizedType) {
            AnnotatedParameterizedType parameterizedExtractedType = (AnnotatedParameterizedType)extractedType;
            int i = 0;
            for (AnnotatedType typeArgument : parameterizedExtractedType.getAnnotatedActualTypeArguments()) {
                if (typeArgument.isAnnotationPresent(ExtractedValue.class)) {
                    if (extractedTypeParameter != null) {
                        throw LOG.getValueExtractorDeclaresExtractedValueMultipleTimesException(extractorImplementationType);
                    }
                    extractedTypeParameter = extractedTypeRaw.getTypeParameters()[i];
                }
                ++i;
            }
        }
        if (extractedTypeParameter == null) {
            throw LOG.getValueExtractorFailsToDeclareExtractedValueException(extractorImplementationType);
        }
        return extractedTypeParameter;
    }

    private static Class<?> getExtractedType(Class<? extends ValueExtractor> extractorImplementationType) {
        AnnotatedParameterizedType genericInterface = ValueExtractorDescriptor.getValueExtractorDefinition(extractorImplementationType);
        AnnotatedType extractedType = genericInterface.getAnnotatedActualTypeArguments()[0];
        return TypeHelper.getErasedReferenceType(extractedType.getType());
    }

    private static AnnotatedParameterizedType getValueExtractorDefinition(Class<?> extractorImplementationType) {
        ArrayList<AnnotatedType> valueExtractorAnnotatedTypes = new ArrayList<AnnotatedType>();
        ValueExtractorDescriptor.determineValueExtractorDefinitions(valueExtractorAnnotatedTypes, extractorImplementationType);
        if (valueExtractorAnnotatedTypes.size() == 1) {
            return (AnnotatedParameterizedType)valueExtractorAnnotatedTypes.get(0);
        }
        if (valueExtractorAnnotatedTypes.size() > 1) {
            throw LOG.getParallelDefinitionsOfValueExtractorException(extractorImplementationType);
        }
        throw new AssertionError((Object)(extractorImplementationType.getName() + " should be a subclass of " + ValueExtractor.class.getSimpleName()));
    }

    private static void determineValueExtractorDefinitions(List<AnnotatedType> valueExtractorDefinitions, Class<?> extractorImplementationType) {
        if (!ValueExtractor.class.isAssignableFrom(extractorImplementationType)) {
            return;
        }
        Class<?> superClass = extractorImplementationType.getSuperclass();
        if (superClass != null && !Object.class.equals(superClass)) {
            ValueExtractorDescriptor.determineValueExtractorDefinitions(valueExtractorDefinitions, superClass);
        }
        for (Class<?> clazz : extractorImplementationType.getInterfaces()) {
            if (ValueExtractor.class.equals(clazz)) continue;
            ValueExtractorDescriptor.determineValueExtractorDefinitions(valueExtractorDefinitions, clazz);
        }
        for (AnnotatedElement annotatedElement : extractorImplementationType.getAnnotatedInterfaces()) {
            if (!ValueExtractor.class.equals(ReflectionHelper.getClassFromType(annotatedElement.getType()))) continue;
            valueExtractorDefinitions.add((AnnotatedType)annotatedElement);
        }
    }

    private static boolean hasUnwrapByDefaultAnnotation(Class<?> extractorImplementationType) {
        return extractorImplementationType.isAnnotationPresent(UnwrapByDefault.class);
    }

    public Key getKey() {
        return this.key;
    }

    public Class<?> getExtractedType() {
        return this.key.extractedType;
    }

    public TypeVariable<?> getExtractedTypeParameter() {
        return this.key.extractedTypeParameter;
    }

    public ValueExtractor<?> getValueExtractor() {
        return this.valueExtractor;
    }

    public boolean isUnwrapByDefault() {
        return this.unwrapByDefault;
    }

    public String toString() {
        return "ValueExtractorDescriptor [key=" + this.key + ", valueExtractor=" + this.valueExtractor + ", unwrapByDefault=" + this.unwrapByDefault + "]";
    }

    public static class Key {
        private final Class<?> extractedType;
        private final TypeVariable<?> extractedTypeParameter;
        private final int hashCode;

        public Key(Class<?> extractedType, TypeVariable<?> extractedTypeParameter) {
            this.extractedType = extractedType;
            this.extractedTypeParameter = extractedTypeParameter;
            this.hashCode = Key.buildHashCode(extractedType, extractedTypeParameter);
        }

        private static int buildHashCode(Type extractedType, TypeVariable<?> extractedTypeParameter) {
            int prime = 31;
            int result = 1;
            result = 31 * result + extractedType.hashCode();
            result = 31 * result + extractedTypeParameter.hashCode();
            return result;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            return this.extractedType.equals(other.extractedType) && this.extractedTypeParameter.equals(other.extractedTypeParameter);
        }

        public String toString() {
            return "Key [extractedType=" + StringHelper.toShortString(this.extractedType) + ", extractedTypeParameter=" + this.extractedTypeParameter + "]";
        }
    }
}

