/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.constraintvalidators.bv;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.hibernate.validator.internal.constraintvalidators.bv.BasePositiveValidator;

public class PositiveValidatorForNumber
extends BasePositiveValidator<Number> {
    private static final short SHORT_ZERO = 0;
    private static final byte BYTE_ZERO = 0;

    @Override
    protected int compare(Number value) {
        int comparisonResult;
        if (value instanceof Double) {
            if ((Double)value == Double.POSITIVE_INFINITY) {
                return 1;
            }
            if (Double.isNaN((Double)value) || (Double)value == Double.NEGATIVE_INFINITY) {
                return -1;
            }
        } else if (value instanceof Float) {
            if (((Float)value).floatValue() == Float.POSITIVE_INFINITY) {
                return 1;
            }
            if (Float.isNaN(((Float)value).floatValue()) || ((Float)value).floatValue() == Float.NEGATIVE_INFINITY) {
                return -1;
            }
        }
        if (value instanceof BigDecimal) {
            comparisonResult = ((BigDecimal)value).compareTo(BigDecimal.ZERO);
        } else if (value instanceof BigInteger) {
            comparisonResult = ((BigInteger)value).compareTo(BigInteger.ZERO);
        } else if (value instanceof Long) {
            comparisonResult = ((Long)value).compareTo(0L);
        } else if (value instanceof Integer) {
            comparisonResult = ((Integer)value).compareTo(0);
        } else if (value instanceof Float) {
            comparisonResult = ((Float)value).compareTo(Float.valueOf(0.0f));
        } else if (value instanceof Double) {
            comparisonResult = ((Double)value).compareTo(0.0);
        } else if (value instanceof Short) {
            comparisonResult = ((Short)value).compareTo((short)0);
        } else if (value instanceof Byte) {
            comparisonResult = ((Byte)value).compareTo((byte)0);
        } else {
            return Double.compare(value.doubleValue(), 0.0);
        }
        return comparisonResult;
    }
}

