/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.testutil;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import org.hibernate.validator.testutil.CountValidationCalls;

public class CountValidationCallsValidator
implements ConstraintValidator<CountValidationCalls, Object> {
    private static final ThreadLocal<Integer> NUMBER_OF_VALIDATION_CALLS = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };

    public static void init() {
        NUMBER_OF_VALIDATION_CALLS.set(0);
    }

    public static int getNumberOfValidationCall() {
        return NUMBER_OF_VALIDATION_CALLS.get();
    }

    public void initialize(CountValidationCalls constraintAnnotation) {
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        NUMBER_OF_VALIDATION_CALLS.set(NUMBER_OF_VALIDATION_CALLS.get() + 1);
        return true;
    }
}

