/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.testutil;

import jakarta.validation.ParameterNameProvider;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PrefixableParameterNameProvider
implements ParameterNameProvider {
    private final String prefix;

    public PrefixableParameterNameProvider(String prefix) {
        this.prefix = prefix;
    }

    public List<String> getParameterNames(Constructor<?> constructor) {
        return this.getParameterNames(constructor.getParameterCount());
    }

    public List<String> getParameterNames(Method method) {
        return this.getParameterNames(method.getParameterCount());
    }

    private List<String> getParameterNames(int parameterCount) {
        ArrayList<String> parameterNames = new ArrayList<String>(parameterCount);
        for (int i = 0; i < parameterCount; ++i) {
            parameterNames.add(this.prefix + i);
        }
        return Collections.unmodifiableList(parameterNames);
    }
}

