/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.testutil;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.ElementKind;
import jakarta.validation.Path;
import jakarta.validation.metadata.ConstraintDescriptor;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.testng.Assert;

public final class ConstraintViolationAssert {
    private static final String CROSS_PARAMETER_NODE_NAME = "<cross-parameter>";
    private static final String RETURN_VALUE_NODE_NAME = "<return value>";

    private ConstraintViolationAssert() {
    }

    public static void assertCorrectConstraintTypes(Set<? extends ConstraintViolation<?>> violations, Class<?> ... expectedConstraintTypes) {
        ArrayList<Class<? extends Annotation>> actualConstraintTypes = new ArrayList<Class<? extends Annotation>>();
        for (ConstraintViolation<?> violation : violations) {
            actualConstraintTypes.add(violation.getConstraintDescriptor().getAnnotation().annotationType());
        }
        ConstraintViolationAssert.assertCorrectConstraintTypes(actualConstraintTypes, expectedConstraintTypes);
    }

    public static void assertCorrectPropertyPathStringRepresentations(Set<? extends ConstraintViolation<?>> violations, String ... expectedPropertyPaths) {
        List actualPaths = violations.stream().map(ConstraintViolation::getPropertyPath).map(Path::toString).collect(Collectors.toList());
        Assertions.assertThat(actualPaths).containsExactlyInAnyOrder((Object[])expectedPropertyPaths);
    }

    public static ConstraintViolationSetAssert assertThat(Set<? extends ConstraintViolation<?>> actualViolations) {
        return new ConstraintViolationSetAssert(actualViolations);
    }

    public static void assertNoViolations(Set<? extends ConstraintViolation<?>> violations) {
        Assertions.assertThat(violations).isEmpty();
    }

    public static void assertNoViolations(Set<? extends ConstraintViolation<?>> violations, String message) {
        ((IterableAssert)Assertions.assertThat(violations).describedAs(message, new Object[0])).isEmpty();
    }

    public static void assertConstraintTypes(Set<? extends ConstraintDescriptor<?>> descriptors, Class<?> ... expectedConstraintTypes) {
        ArrayList<Class<? extends Annotation>> actualConstraintTypes = new ArrayList<Class<? extends Annotation>>();
        for (ConstraintDescriptor<?> descriptor : descriptors) {
            actualConstraintTypes.add(descriptor.getAnnotation().annotationType());
        }
        ConstraintViolationAssert.assertCorrectConstraintTypes(actualConstraintTypes, expectedConstraintTypes);
    }

    public static void assertPathEquals(Path path, PathExpectation expectedPath) {
        Assert.assertEquals((Object)new PathExpectation(path), (Object)expectedPath, (String)"Path does not match");
    }

    public static boolean pathsAreEqual(Path p1, Path p2) {
        Iterator p1Iterator = p1.iterator();
        Iterator p2Iterator = p2.iterator();
        while (p1Iterator.hasNext()) {
            int p2NodeParameterIndex;
            int p1NodeParameterIndex;
            Path.Node p1Node = (Path.Node)p1Iterator.next();
            if (!p2Iterator.hasNext()) {
                return false;
            }
            Path.Node p2Node = (Path.Node)p2Iterator.next();
            if (p1Node.getKind() != p2Node.getKind()) {
                return false;
            }
            if (p2Node.getName() == null ? p1Node.getName() != null : !p2Node.getName().equals(p1Node.getName())) {
                return false;
            }
            if (p2Node.isInIterable() != p1Node.isInIterable()) {
                return false;
            }
            if (p2Node.getIndex() == null ? p1Node.getIndex() != null : !p2Node.getIndex().equals(p1Node.getIndex())) {
                return false;
            }
            if (p2Node.getKey() == null ? p1Node.getKey() != null : !p2Node.getKey().equals(p1Node.getKey())) {
                return false;
            }
            Class<?> p1NodeContainerClass = ConstraintViolationAssert.getContainerClass(p1Node);
            Class<?> p2NodeContainerClass = ConstraintViolationAssert.getContainerClass(p2Node);
            if (p2NodeContainerClass == null ? p1NodeContainerClass != null : !p2NodeContainerClass.equals(p1NodeContainerClass)) {
                return false;
            }
            Integer p1NodeTypeArgumentIndex = ConstraintViolationAssert.getTypeArgumentIndex(p1Node);
            Integer p2NodeTypeArgumentIndex = ConstraintViolationAssert.getTypeArgumentIndex(p2Node);
            if (p2NodeTypeArgumentIndex == null ? p1NodeTypeArgumentIndex != null : !p2NodeTypeArgumentIndex.equals(p1NodeTypeArgumentIndex)) {
                return false;
            }
            if (p1Node.getKind() != ElementKind.PARAMETER || (p1NodeParameterIndex = ((Path.ParameterNode)p1Node.as(Path.ParameterNode.class)).getParameterIndex()) == (p2NodeParameterIndex = ((Path.ParameterNode)p2Node.as(Path.ParameterNode.class)).getParameterIndex())) continue;
            return false;
        }
        return !p2Iterator.hasNext();
    }

    private static <T> void assertCorrectConstraintTypes(Iterable<Class<? extends Annotation>> actualConstraintTypes, Class<?> ... expectedConstraintTypes) {
        Assertions.assertThat(actualConstraintTypes).extracting(Class::getName).containsExactlyInAnyOrder((Object[])Arrays.stream(expectedConstraintTypes).map(c -> c.getName()).toArray(String[]::new));
    }

    public static PathExpectation pathWith() {
        return new PathExpectation();
    }

    public static ViolationExpectation violationOf(Class<? extends Annotation> constraintType) {
        return new ViolationExpectation(constraintType);
    }

    private static Class<?> getContainerClass(Path.Node node) {
        Class containerClass = null;
        if (node.getKind() == ElementKind.PROPERTY) {
            containerClass = ((Path.PropertyNode)node.as(Path.PropertyNode.class)).getContainerClass();
        }
        if (node.getKind() == ElementKind.BEAN) {
            containerClass = ((Path.BeanNode)node.as(Path.BeanNode.class)).getContainerClass();
        }
        if (node.getKind() == ElementKind.CONTAINER_ELEMENT) {
            containerClass = ((Path.ContainerElementNode)node.as(Path.ContainerElementNode.class)).getContainerClass();
        }
        return containerClass;
    }

    private static Integer getTypeArgumentIndex(Path.Node node) {
        Integer typeArgumentIndex = null;
        if (node.getKind() == ElementKind.PROPERTY) {
            typeArgumentIndex = ((Path.PropertyNode)node.as(Path.PropertyNode.class)).getTypeArgumentIndex();
        }
        if (node.getKind() == ElementKind.BEAN) {
            typeArgumentIndex = ((Path.BeanNode)node.as(Path.BeanNode.class)).getTypeArgumentIndex();
        }
        if (node.getKind() == ElementKind.CONTAINER_ELEMENT) {
            typeArgumentIndex = ((Path.ContainerElementNode)node.as(Path.ContainerElementNode.class)).getTypeArgumentIndex();
        }
        return typeArgumentIndex;
    }

    private static class NodeExpectation {
        private final String name;
        private final ElementKind kind;
        private final boolean inIterable;
        private final Object key;
        private final Integer index;
        private final Integer parameterIndex;
        private final Class<?> containerClass;
        private final Integer typeArgumentIndex;

        private NodeExpectation(String name, ElementKind kind) {
            this(name, kind, false, null, null, null, null, null);
        }

        private NodeExpectation(String name, ElementKind kind, boolean inIterable, Object key, Integer index, Integer parameterIndex, Class<?> containerClass, Integer typeArgumentIndex) {
            this.name = name;
            this.kind = kind;
            this.inIterable = inIterable;
            this.key = key;
            this.index = index;
            this.parameterIndex = parameterIndex;
            this.containerClass = containerClass;
            this.typeArgumentIndex = typeArgumentIndex;
        }

        public String toString() {
            return "NodeExpectation(" + this.name + ", " + this.kind + ", " + this.inIterable + ", " + this.key + ", " + this.index + ", " + this.parameterIndex + ", " + this.containerClass + ", " + this.typeArgumentIndex + ")";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.inIterable ? 1231 : 1237);
            result = 31 * result + (this.index == null ? 0 : this.index.hashCode());
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + (this.kind == null ? 0 : this.kind.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.parameterIndex == null ? 0 : this.parameterIndex.hashCode());
            result = 31 * result + (this.containerClass == null ? 0 : this.containerClass.hashCode());
            result = 31 * result + (this.typeArgumentIndex == null ? 0 : this.typeArgumentIndex.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NodeExpectation other = (NodeExpectation)obj;
            if (this.inIterable != other.inIterable) {
                return false;
            }
            if (this.index == null ? other.index != null : !this.index.equals(other.index)) {
                return false;
            }
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            if (this.kind != other.kind) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.parameterIndex == null ? other.parameterIndex != null : !this.parameterIndex.equals(other.parameterIndex)) {
                return false;
            }
            if (this.containerClass == null ? other.containerClass != null : !this.containerClass.equals(other.containerClass)) {
                return false;
            }
            return !(this.typeArgumentIndex == null ? other.typeArgumentIndex != null : !this.typeArgumentIndex.equals(other.typeArgumentIndex));
        }
    }

    public static class PathExpectation {
        private final List<NodeExpectation> nodes = new ArrayList<NodeExpectation>();

        private PathExpectation() {
        }

        private PathExpectation(Path propertyPath) {
            for (Path.Node node : propertyPath) {
                Integer parameterIndex = null;
                if (node.getKind() == ElementKind.PARAMETER) {
                    parameterIndex = ((Path.ParameterNode)node.as(Path.ParameterNode.class)).getParameterIndex();
                }
                Class containerClass = ConstraintViolationAssert.getContainerClass(node);
                Integer typeArgumentIndex = ConstraintViolationAssert.getTypeArgumentIndex(node);
                this.nodes.add(new NodeExpectation(node.getName(), node.getKind(), node.isInIterable(), node.getKey(), node.getIndex(), parameterIndex, containerClass, typeArgumentIndex));
            }
        }

        public PathExpectation property(String name) {
            this.nodes.add(new NodeExpectation(name, ElementKind.PROPERTY));
            return this;
        }

        public PathExpectation property(String name, Class<?> containerClass, Integer typeArgumentIndex) {
            this.nodes.add(new NodeExpectation(name, ElementKind.PROPERTY, false, null, null, null, containerClass, typeArgumentIndex));
            return this;
        }

        public PathExpectation property(String name, boolean inIterable, Object key, Integer index) {
            this.nodes.add(new NodeExpectation(name, ElementKind.PROPERTY, inIterable, key, index, null, null, null));
            return this;
        }

        public PathExpectation property(String name, boolean inIterable, Object key, Integer index, Class<?> containerClass, Integer typeArgumentIndex) {
            this.nodes.add(new NodeExpectation(name, ElementKind.PROPERTY, inIterable, key, index, null, containerClass, typeArgumentIndex));
            return this;
        }

        public PathExpectation bean() {
            this.nodes.add(new NodeExpectation(null, ElementKind.BEAN));
            return this;
        }

        public PathExpectation bean(boolean inIterable, Object key, Integer index) {
            this.nodes.add(new NodeExpectation(null, ElementKind.BEAN, inIterable, key, index, null, null, null));
            return this;
        }

        public PathExpectation bean(boolean inIterable, Object key, Integer index, Class<?> containerClass, Integer typeArgumentIndex) {
            this.nodes.add(new NodeExpectation(null, ElementKind.BEAN, inIterable, key, index, null, containerClass, typeArgumentIndex));
            return this;
        }

        public PathExpectation constructor(Class<?> clazz) {
            this.nodes.add(new NodeExpectation(clazz.getSimpleName(), ElementKind.CONSTRUCTOR));
            return this;
        }

        public PathExpectation method(String name) {
            this.nodes.add(new NodeExpectation(name, ElementKind.METHOD));
            return this;
        }

        public PathExpectation parameter(String name, int index) {
            this.nodes.add(new NodeExpectation(name, ElementKind.PARAMETER, false, null, null, index, null, null));
            return this;
        }

        public PathExpectation crossParameter() {
            this.nodes.add(new NodeExpectation(ConstraintViolationAssert.CROSS_PARAMETER_NODE_NAME, ElementKind.CROSS_PARAMETER));
            return this;
        }

        public PathExpectation returnValue() {
            this.nodes.add(new NodeExpectation(ConstraintViolationAssert.RETURN_VALUE_NODE_NAME, ElementKind.RETURN_VALUE));
            return this;
        }

        public PathExpectation containerElement(String name, boolean inIterable, Object key, Integer index, Class<?> containerClass, Integer typeArgumentIndex) {
            this.nodes.add(new NodeExpectation(name, ElementKind.CONTAINER_ELEMENT, inIterable, key, index, null, containerClass, typeArgumentIndex));
            return this;
        }

        public String toString() {
            String lineBreak = System.getProperty("line.separator");
            StringBuilder asString = new StringBuilder(lineBreak + "PathExpectation(" + lineBreak);
            for (NodeExpectation node : this.nodes) {
                asString.append("  ").append(node).append(lineBreak);
            }
            return asString.append(")").toString();
        }

        public String toStringInViolation() {
            String lineBreak = System.getProperty("line.separator");
            StringBuilder asString = new StringBuilder("PathExpectation(" + lineBreak);
            for (NodeExpectation node : this.nodes) {
                asString.append("    ").append(node).append(lineBreak);
            }
            return asString.append("  )").toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.nodes == null ? 0 : this.nodes.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PathExpectation other = (PathExpectation)obj;
            return !(this.nodes == null ? other.nodes != null : !this.nodes.equals(other.nodes));
        }
    }

    private static class ViolationExpectationPropertiesToTest {
        private boolean testRootBeanClass = false;
        private boolean testMessage = false;
        private boolean testInvalidValue = false;
        private boolean testPropertyPath = false;

        private ViolationExpectationPropertiesToTest() {
        }

        private static ViolationExpectationPropertiesToTest all() {
            ViolationExpectationPropertiesToTest propertiesToTest = new ViolationExpectationPropertiesToTest().testRootBeanClass().testMessage().testInvalidValue().testPropertyPath();
            return propertiesToTest;
        }

        private ViolationExpectationPropertiesToTest testRootBeanClass() {
            this.testRootBeanClass = true;
            return this;
        }

        private ViolationExpectationPropertiesToTest testMessage() {
            this.testMessage = true;
            return this;
        }

        private ViolationExpectationPropertiesToTest testInvalidValue() {
            this.testInvalidValue = true;
            return this;
        }

        private ViolationExpectationPropertiesToTest testPropertyPath() {
            this.testPropertyPath = true;
            return this;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.testRootBeanClass ? 1 : 0);
            result = 31 * result + (this.testMessage ? 1 : 0);
            result = 31 * result + (this.testInvalidValue ? 1 : 0);
            result = 31 * result + (this.testPropertyPath ? 1 : 0);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ViolationExpectationPropertiesToTest other = (ViolationExpectationPropertiesToTest)obj;
            if (this.testRootBeanClass != other.testRootBeanClass) {
                return false;
            }
            if (this.testMessage != other.testMessage) {
                return false;
            }
            if (this.testInvalidValue != other.testInvalidValue) {
                return false;
            }
            return this.testPropertyPath == other.testPropertyPath;
        }
    }

    public static class ViolationExpectation {
        private final ViolationExpectationPropertiesToTest propertiesToTest = new ViolationExpectationPropertiesToTest();
        private final Class<? extends Annotation> constraintType;
        private Class<?> rootBeanClass;
        private String message;
        private Object invalidValue;
        private PathExpectation propertyPath;

        private ViolationExpectation(Class<? extends Annotation> constraintType) {
            this.constraintType = constraintType;
        }

        private ViolationExpectation(ConstraintViolation<?> violation, ViolationExpectationPropertiesToTest propertiesToTest) {
            this.constraintType = violation.getConstraintDescriptor().getAnnotation().annotationType();
            if (propertiesToTest.testRootBeanClass) {
                this.withRootBeanClass(violation.getRootBeanClass());
            }
            if (propertiesToTest.testMessage) {
                this.withMessage(violation.getMessage());
            }
            if (propertiesToTest.testInvalidValue) {
                this.withInvalidValue(violation.getInvalidValue());
            }
            if (propertiesToTest.testPropertyPath) {
                this.withPropertyPath(new PathExpectation(violation.getPropertyPath()));
            }
        }

        public ViolationExpectation withRootBeanClass(Class<?> rootBeanClass) {
            this.propertiesToTest.testRootBeanClass();
            this.rootBeanClass = rootBeanClass;
            return this;
        }

        public ViolationExpectation withMessage(String message) {
            this.propertiesToTest.testMessage();
            this.message = message;
            return this;
        }

        public ViolationExpectation withInvalidValue(Object invalidValue) {
            this.propertiesToTest.testInvalidValue();
            this.invalidValue = invalidValue;
            return this;
        }

        public ViolationExpectation withPropertyPath(PathExpectation propertyPath) {
            this.propertiesToTest.testPropertyPath();
            this.propertyPath = propertyPath;
            return this;
        }

        public ViolationExpectation withProperty(String property) {
            return this.withPropertyPath(new PathExpectation().property(property));
        }

        public String toString() {
            String lineBreak = System.getProperty("line.separator");
            StringBuilder asString = new StringBuilder(lineBreak + "ViolationExpectation(" + lineBreak);
            asString.append("  constraintType: ").append(this.constraintType).append(lineBreak);
            if (this.propertiesToTest.testRootBeanClass) {
                asString.append("  rootBeanClass: ").append(this.rootBeanClass).append(lineBreak);
            }
            if (this.propertiesToTest.testMessage) {
                asString.append("  message: ").append(this.message).append(lineBreak);
            }
            if (this.propertiesToTest.testInvalidValue) {
                asString.append("  invalidValue: ").append(this.invalidValue).append(lineBreak);
            }
            if (this.propertiesToTest.testPropertyPath) {
                asString.append("  propertyPath: ").append(this.propertyPath.toStringInViolation()).append(lineBreak);
            }
            return asString.append(")").toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.constraintType == null ? 0 : this.constraintType.hashCode());
            if (this.propertiesToTest.testRootBeanClass) {
                result = 31 * result + (this.rootBeanClass == null ? 0 : this.rootBeanClass.hashCode());
            }
            if (this.propertiesToTest.testMessage) {
                result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
            }
            if (this.propertiesToTest.testInvalidValue) {
                result = 31 * result + (this.invalidValue == null ? 0 : this.invalidValue.hashCode());
            }
            if (this.propertiesToTest.testPropertyPath) {
                result = 31 * result + (this.propertyPath == null ? 0 : this.propertyPath.hashCode());
            }
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ViolationExpectation other = (ViolationExpectation)obj;
            if (this.constraintType == null ? other.constraintType != null : !this.constraintType.equals(other.constraintType)) {
                return false;
            }
            if (this.propertiesToTest.testRootBeanClass && (this.rootBeanClass == null ? other.rootBeanClass != null : !this.rootBeanClass.equals(other.rootBeanClass))) {
                return false;
            }
            if (this.propertiesToTest.testMessage && (this.message == null ? other.message != null : !this.message.equals(other.message))) {
                return false;
            }
            if (this.propertiesToTest.testInvalidValue && (this.invalidValue == null ? other.invalidValue != null : !this.invalidValue.equals(other.invalidValue))) {
                return false;
            }
            return !this.propertiesToTest.testPropertyPath || !(this.propertyPath == null ? other.propertyPath != null : !this.propertyPath.equals(other.propertyPath));
        }
    }

    public static class ConstraintViolationSetAssert
    extends IterableAssert<ConstraintViolation<?>> {
        protected ConstraintViolationSetAssert(Set<? extends ConstraintViolation<?>> actualViolations) {
            super(actualViolations);
        }

        public ConstraintViolationSetAssert describedAs(String description, Object ... args) {
            return (ConstraintViolationSetAssert)super.describedAs(description, args);
        }

        public void containsOnlyViolations(ViolationExpectation ... expectedViolations) {
            this.isNotNull();
            List<ViolationExpectation> actualViolations = this.getActualViolationExpectations(expectedViolations);
            Assertions.assertThat(actualViolations).containsExactlyInAnyOrder((Object[])expectedViolations);
        }

        public void containsOneOfViolations(ViolationExpectation ... expectedViolations) {
            this.isNotNull();
            List<ViolationExpectation> actualViolations = this.getActualViolationExpectations(expectedViolations);
            Assertions.assertThat(actualViolations).hasSize(1);
            Assertions.assertThat((Object[])expectedViolations).contains((Object[])new ViolationExpectation[]{actualViolations.get(0)});
        }

        private List<ViolationExpectation> getActualViolationExpectations(ViolationExpectation[] expectedViolations) {
            ViolationExpectationPropertiesToTest referencePropertiesToTest;
            ArrayList<ViolationExpectation> actualViolations = new ArrayList<ViolationExpectation>();
            if (expectedViolations.length == 0) {
                referencePropertiesToTest = ViolationExpectationPropertiesToTest.all();
            } else {
                referencePropertiesToTest = expectedViolations[0].propertiesToTest;
                for (ViolationExpectation expectedViolation : expectedViolations) {
                    if (referencePropertiesToTest.equals(expectedViolation.propertiesToTest)) continue;
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected violations passed in parameter must test the exact same properties but do not: %1$s != %2$s", expectedViolations[0], expectedViolation));
                }
            }
            for (ConstraintViolation violation : (Iterable)this.actual) {
                actualViolations.add(new ViolationExpectation(violation, referencePropertiesToTest));
            }
            return actualViolations;
        }

        public void containsOnlyPaths(PathExpectation ... paths) {
            this.isNotNull();
            ArrayList<PathExpectation> actualPaths = new ArrayList<PathExpectation>();
            for (ConstraintViolation violation : (Iterable)this.actual) {
                actualPaths.add(new PathExpectation(violation.getPropertyPath()));
            }
            Assertions.assertThat(actualPaths).containsExactlyInAnyOrder((Object[])paths);
        }

        public void containsPath(PathExpectation expectedPath) {
            this.isNotNull();
            ArrayList<PathExpectation> actualPaths = new ArrayList<PathExpectation>();
            for (ConstraintViolation violation : (Iterable)this.actual) {
                PathExpectation actual = new PathExpectation(violation.getPropertyPath());
                if (actual.equals(expectedPath)) {
                    return;
                }
                actualPaths.add(actual);
            }
            Assert.fail((String)String.format(Locale.ROOT, "Didn't find path <%s> in actual paths <%s>.", expectedPath, actualPaths));
        }

        public void containsPaths(PathExpectation ... expectedPaths) {
            for (PathExpectation pathExpectation : expectedPaths) {
                this.containsPath(pathExpectation);
            }
        }
    }
}

