/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.testutil;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;

public class ValidationInvocationHandler
implements InvocationHandler {
    private static final Object[] EMPTY_ARGS = new Object[0];
    private final Object wrapped;
    private final Validator validator;
    private final Class<?>[] groups;

    public ValidationInvocationHandler(Object wrapped, Validator validator, Class<?> ... groups) {
        this.wrapped = wrapped;
        this.validator = validator;
        this.groups = groups;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Set constraintViolations = this.validator.forExecutables().validateParameters(this.wrapped, method, args == null ? EMPTY_ARGS : args, (Class[])this.groups);
        if (!constraintViolations.isEmpty()) {
            throw new ConstraintViolationException(new HashSet(constraintViolations));
        }
        Object result = method.invoke(this.wrapped, args);
        constraintViolations = this.validator.forExecutables().validateReturnValue(this.wrapped, method, result, (Class[])this.groups);
        if (!constraintViolations.isEmpty()) {
            throw new ConstraintViolationException(new HashSet(constraintViolations));
        }
        return result;
    }
}

