/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.internal.reveng.reader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Table;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.api.reveng.RevengDialect;
import org.hibernate.tool.api.reveng.RevengStrategy;
import org.hibernate.tool.internal.reveng.RevengMetadataCollector;
import org.hibernate.tool.internal.reveng.reader.ForeignKeyProcessor;
import org.hibernate.tool.internal.reveng.reader.ForeignKeysInfo;
import org.hibernate.tool.internal.reveng.reader.TableCollector;

public class DatabaseReader {
    private final RevengStrategy revengStrategy;
    private RevengDialect metadataDialect;
    private final ConnectionProvider provider;
    private final Properties properties;

    public static DatabaseReader create(Properties properties, RevengStrategy revengStrategy, RevengDialect mdd, ServiceRegistry serviceRegistry) {
        ConnectionProvider connectionProvider = (ConnectionProvider)serviceRegistry.getService(ConnectionProvider.class);
        return new DatabaseReader(properties, mdd, connectionProvider, revengStrategy);
    }

    private DatabaseReader(Properties properties, RevengDialect dialect, ConnectionProvider provider, RevengStrategy reveng) {
        this.metadataDialect = dialect;
        this.provider = provider;
        this.revengStrategy = reveng;
        this.properties = properties;
        if (this.revengStrategy == null) {
            throw new IllegalStateException("Strategy cannot be null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readDatabaseSchema(RevengMetadataCollector revengMetadataCollector) {
        try {
            this.metadataDialect.configure(this.provider);
            TableCollector tableCollector = TableCollector.create(this.metadataDialect, this.revengStrategy, revengMetadataCollector, this.properties);
            Iterator<RevengStrategy.SchemaSelection> iter = this.getSchemaSelections().iterator();
            while (iter.hasNext()) {
                tableCollector.processTables(iter.next());
            }
            revengMetadataCollector.setOneToManyCandidates(this.resolveForeignKeys(revengMetadataCollector));
        }
        finally {
            this.metadataDialect.close();
            this.revengStrategy.close();
        }
    }

    private Map<String, List<ForeignKey>> resolveForeignKeys(RevengMetadataCollector revengMetadataCollector) {
        ArrayList<ForeignKeysInfo> fks = new ArrayList<ForeignKeysInfo>();
        ForeignKeyProcessor foreignKeyProcessor = ForeignKeyProcessor.create(this.metadataDialect, this.revengStrategy, this.getDefaultCatalog(), this.getDefaultSchema(), revengMetadataCollector);
        for (Table table : revengMetadataCollector.getTables()) {
            ForeignKeysInfo foreignKeys = foreignKeyProcessor.processForeignKeys(table);
            fks.add(foreignKeys);
        }
        HashMap<String, List<ForeignKey>> oneToManyCandidates = new HashMap<String, List<ForeignKey>>();
        for (ForeignKeysInfo element : fks) {
            Map<String, List<ForeignKey>> map = element.process(this.revengStrategy);
            this.mergeMultiMap(oneToManyCandidates, map);
        }
        return oneToManyCandidates;
    }

    private void mergeMultiMap(Map<String, List<ForeignKey>> dest, Map<String, List<ForeignKey>> src) {
        for (Map.Entry<String, List<ForeignKey>> element : src.entrySet()) {
            List<ForeignKey> existing = dest.get(element.getKey());
            if (existing == null) {
                dest.put(element.getKey(), element.getValue());
                continue;
            }
            existing.addAll((Collection<ForeignKey>)element.getValue());
        }
    }

    private List<RevengStrategy.SchemaSelection> getSchemaSelections() {
        List<RevengStrategy.SchemaSelection> result = this.revengStrategy.getSchemaSelections();
        if (result == null) {
            result = new ArrayList<RevengStrategy.SchemaSelection>();
            result.add(new RevengStrategy.SchemaSelection(){

                @Override
                public String getMatchCatalog() {
                    return DatabaseReader.this.getDefaultCatalog();
                }

                @Override
                public String getMatchSchema() {
                    return DatabaseReader.this.getDefaultSchema();
                }

                @Override
                public String getMatchTable() {
                    return null;
                }
            });
        }
        return result;
    }

    private String getDefaultSchema() {
        return this.properties.getProperty("hibernate.default_schema");
    }

    private String getDefaultCatalog() {
        return this.properties.getProperty("hibernate.default_catalog");
    }
}

