/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.internal.reveng.binder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.ForeignKey;

public class ForeignKeyUtils {
    public static boolean isUniqueReference(ForeignKey foreignKey) {
        Iterator foreignKeyIterator = foreignKey.getTable().getForeignKeyIterator();
        while (foreignKeyIterator.hasNext()) {
            ForeignKey element = (ForeignKey)foreignKeyIterator.next();
            if (element == foreignKey || !element.getReferencedTable().equals(foreignKey.getReferencedTable())) continue;
            return false;
        }
        return true;
    }

    public static List<Object> findForeignKeys(Iterator<?> foreignKeyIterator, List<Column> pkColumns) {
        ArrayList<ForeignKey> tempList = new ArrayList<ForeignKey>();
        while (foreignKeyIterator.hasNext()) {
            tempList.add((ForeignKey)foreignKeyIterator.next());
        }
        ArrayList<Object> result = new ArrayList<Object>();
        Column[] myPkColumns = pkColumns.toArray(new Column[pkColumns.size()]);
        for (int i = 0; i < myPkColumns.length; ++i) {
            boolean foundKey = false;
            foreignKeyIterator = tempList.iterator();
            while (foreignKeyIterator.hasNext()) {
                ForeignKey key = (ForeignKey)foreignKeyIterator.next();
                List<Column> matchingColumns = ForeignKeyUtils.columnMatches(myPkColumns, i, key);
                if (matchingColumns.isEmpty()) continue;
                result.add(new ForeignKeyForColumns(key, matchingColumns));
                i += matchingColumns.size() - 1;
                foreignKeyIterator.remove();
                foundKey = true;
                break;
            }
            if (foundKey) continue;
            result.add(myPkColumns[i]);
        }
        return result;
    }

    private static List<Column> columnMatches(Column[] pkColumns, int offset, ForeignKey fk) {
        ArrayList<Column> result = new ArrayList<Column>();
        int columnSpan = fk.getColumnSpan();
        if (columnSpan <= pkColumns.length - offset) {
            for (int i = 0; i < columnSpan; ++i) {
                Column column = pkColumns[i + offset];
                if (!column.equals(fk.getColumn(i))) {
                    result.clear();
                    break;
                }
                result.add(column);
            }
        }
        return result;
    }

    public static class ForeignKeyForColumns {
        public final List<Column> columns;
        public final ForeignKey key;

        public ForeignKeyForColumns(ForeignKey key, List<Column> columns) {
            this.key = key;
            this.columns = columns;
        }
    }
}

