/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.internal.reveng.binder;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hibernate.FetchMode;
import org.hibernate.internal.util.collections.JoinedIterator;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Fetchable;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.tool.api.reveng.AssociationInfo;
import org.hibernate.tool.api.reveng.RevengStrategy;

public class BinderUtils {
    public static Logger LOGGER = Logger.getLogger(BinderUtils.class.getName());

    public static String makeUnique(Iterator<Property> props, String originalPropertyName) {
        int cnt = 0;
        String propertyName = originalPropertyName;
        HashSet<String> uniqueNames = new HashSet<String>();
        while (props.hasNext()) {
            Property element = props.next();
            uniqueNames.add(element.getName());
        }
        while (uniqueNames.contains(propertyName)) {
            propertyName = originalPropertyName + "_" + ++cnt;
        }
        return propertyName;
    }

    public static String makeUnique(PersistentClass clazz, String propertyName) {
        ArrayList<Property> list = new ArrayList<Property>();
        if (clazz.hasIdentifierProperty()) {
            list.add(clazz.getIdentifierProperty());
        }
        if (clazz.isVersioned()) {
            list.add(clazz.getVersion());
        }
        Iterator propertyClosureIterator = clazz.getPropertyClosureIterator();
        JoinedIterator iterator = new JoinedIterator(new Iterator[]{list.iterator(), propertyClosureIterator});
        return BinderUtils.makeUnique((Iterator<Property>)iterator, propertyName);
    }

    public static String makeUnique(Component clazz, String propertyName) {
        return BinderUtils.makeUnique(clazz.getPropertyIterator(), propertyName);
    }

    public static void checkColumnForMultipleBinding(Column column) {
        if (column.getValue() != null) {
            LOGGER.log(Level.WARNING, "Binding column twice should not happen. " + column);
        }
    }

    static void updateFetchMode(Fetchable value, String fetchMode) {
        if (FetchMode.JOIN.toString().equalsIgnoreCase(fetchMode)) {
            value.setFetchMode(FetchMode.JOIN);
        } else {
            value.setFetchMode(FetchMode.SELECT);
        }
    }

    static AssociationInfo getAssociationInfo(RevengStrategy revengStrategy, ForeignKey foreignKey, boolean inverseProperty) {
        if (inverseProperty) {
            return revengStrategy.foreignKeyToInverseAssociationInfo(foreignKey);
        }
        return revengStrategy.foreignKeyToAssociationInfo(foreignKey);
    }
}

