/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.internal.reveng;

import java.util.Map;
import java.util.Properties;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.internal.BootstrapContextImpl;
import org.hibernate.boot.internal.InFlightMetadataCollectorImpl;
import org.hibernate.boot.internal.MetadataBuilderImpl;
import org.hibernate.boot.internal.MetadataBuildingContextRootImpl;
import org.hibernate.boot.internal.MetadataImpl;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.MetadataBuildingOptions;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.mapping.Table;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.api.reveng.RevengDialect;
import org.hibernate.tool.api.reveng.RevengDialectFactory;
import org.hibernate.tool.api.reveng.RevengStrategy;
import org.hibernate.tool.internal.reveng.RevengMetadataCollector;
import org.hibernate.tool.internal.reveng.binder.BinderContext;
import org.hibernate.tool.internal.reveng.binder.RootClassBinder;
import org.hibernate.tool.internal.reveng.reader.DatabaseReader;
import org.jboss.logging.Logger;

public class RevengMetadataBuilder {
    private static final Logger LOGGER = Logger.getLogger(RevengMetadataBuilder.class);
    private final Properties properties;
    private final MetadataBuildingContext metadataBuildingContext;
    private final InFlightMetadataCollectorImpl metadataCollector;
    private final RevengStrategy revengStrategy;
    private final BinderContext binderContext;
    private final StandardServiceRegistry serviceRegistry;

    public static RevengMetadataBuilder create(Properties properties, RevengStrategy reverseEngineeringStrategy) {
        return new RevengMetadataBuilder(properties, reverseEngineeringStrategy);
    }

    private RevengMetadataBuilder(Properties properties, RevengStrategy reverseEngineeringStrategy) {
        this.properties = properties;
        this.revengStrategy = reverseEngineeringStrategy;
        this.serviceRegistry = new StandardServiceRegistryBuilder().applySettings((Map)properties).build();
        MetadataBuilderImpl.MetadataBuildingOptionsImpl metadataBuildingOptions = new MetadataBuilderImpl.MetadataBuildingOptionsImpl(this.serviceRegistry);
        BootstrapContextImpl bootstrapContext = new BootstrapContextImpl(this.serviceRegistry, (MetadataBuildingOptions)metadataBuildingOptions);
        metadataBuildingOptions.setBootstrapContext(bootstrapContext);
        this.metadataCollector = new InFlightMetadataCollectorImpl((BootstrapContext)bootstrapContext, (MetadataBuildingOptions)metadataBuildingOptions);
        this.metadataBuildingContext = new MetadataBuildingContextRootImpl("tools", (BootstrapContext)bootstrapContext, (MetadataBuildingOptions)metadataBuildingOptions, (InFlightMetadataCollector)this.metadataCollector);
        this.binderContext = BinderContext.create(this.metadataBuildingContext, (InFlightMetadataCollector)this.metadataCollector, reverseEngineeringStrategy, properties);
    }

    public Metadata build() {
        MetadataImpl result = this.createMetadata();
        this.createPersistentClasses(this.readFromDatabase());
        return result;
    }

    private MetadataImpl createMetadata() {
        MetadataImpl result = this.metadataCollector.buildMetadataInstance(this.metadataBuildingContext);
        result.getTypeConfiguration().scope(this.metadataBuildingContext);
        return result;
    }

    private RevengMetadataCollector readFromDatabase() {
        RevengDialect mdd = RevengDialectFactory.createMetaDataDialect(((JdbcServices)this.serviceRegistry.getService(JdbcServices.class)).getDialect(), this.properties);
        DatabaseReader reader = DatabaseReader.create(this.properties, this.revengStrategy, mdd, (ServiceRegistry)this.serviceRegistry);
        RevengMetadataCollector revengMetadataCollector = new RevengMetadataCollector(this.metadataBuildingContext);
        reader.readDatabaseSchema(revengMetadataCollector);
        return revengMetadataCollector;
    }

    private void createPersistentClasses(RevengMetadataCollector revengMetadataCollector) {
        RootClassBinder rootClassBinder = RootClassBinder.create(this.binderContext);
        for (Table table : this.metadataCollector.collectTableMappings()) {
            if (table.getColumnSpan() == 0) {
                LOGGER.warn((Object)("Cannot create persistent class for " + table + " as no columns were found."));
                continue;
            }
            if (this.revengStrategy.isManyToManyTable(table)) {
                LOGGER.debug((Object)("Ignoring " + table + " as class since rev.eng. says it is a many-to-many"));
                continue;
            }
            rootClassBinder.bind(table, revengMetadataCollector);
        }
        this.metadataCollector.processSecondPasses(this.metadataBuildingContext);
    }
}

