/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.api.reveng;

import java.io.File;
import org.hibernate.tool.api.reveng.RevengStrategy;
import org.hibernate.tool.internal.reveng.strategy.DefaultStrategy;
import org.hibernate.tool.internal.reveng.strategy.OverrideRepository;
import org.hibernate.tool.util.ReflectionUtil;

public class RevengStrategyFactory {
    private static final String DEFAULT_REVERSE_ENGINEERING_STRATEGY_CLASS_NAME = DefaultStrategy.class.getName();

    public static RevengStrategy createReverseEngineeringStrategy(String reverseEngineeringClassName) {
        RevengStrategy result = null;
        try {
            Class reverseEngineeringClass = ReflectionUtil.classForName((String)(reverseEngineeringClassName == null ? DEFAULT_REVERSE_ENGINEERING_STRATEGY_CLASS_NAME : reverseEngineeringClassName));
            result = (RevengStrategy)reverseEngineeringClass.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException exception) {
            throw new RuntimeException("An exporter of class '" + reverseEngineeringClassName + "' could not be created", exception);
        }
        return result;
    }

    public static RevengStrategy createReverseEngineeringStrategy(String reverseEngineeringClassName, File[] revengFiles) {
        RevengStrategy result = RevengStrategyFactory.createReverseEngineeringStrategy(reverseEngineeringClassName);
        if (revengFiles != null && revengFiles.length > 0) {
            OverrideRepository overrideRepository = new OverrideRepository();
            for (File file : revengFiles) {
                overrideRepository.addFile(file);
            }
            result = overrideRepository.getReverseEngineeringStrategy(result);
        }
        return result;
    }

    public static RevengStrategy createReverseEngineeringStrategy() {
        return RevengStrategyFactory.createReverseEngineeringStrategy(null);
    }
}

