/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.api.java;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public class Formatter {
    private CodeFormatter codeFormatter;

    public Formatter(Map<Object, Object> settings) {
        if (settings == null) {
            settings = new HashMap<Object, Object>();
            settings.put("org.eclipse.jdt.core.compiler.source", "1.5");
            settings.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
            settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
        }
        this.codeFormatter = ToolFactory.createCodeFormatter(settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean formatFile(File file) {
        Document doc = new Document();
        try {
            String contents = new String(Util.getFileCharContent((File)file, null));
            doc.set(contents);
            TextEdit edit = this.codeFormatter.format(8, contents, 0, contents.length(), 0, null);
            if (edit == null) {
                return false;
            }
            edit.apply((IDocument)doc);
            BufferedWriter out = new BufferedWriter(new FileWriter(file));
            try {
                out.write(doc.get());
                out.flush();
            }
            finally {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            return true;
        }
        catch (IOException | BadLocationException e) {
            throw new RuntimeException("Could not format " + file, e);
        }
    }
}

