/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.language.internal;

import jakarta.persistence.Tuple;
import jakarta.persistence.criteria.Selection;
import java.io.IOException;
import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.NullnessUtil;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.SelectionQuery;
import org.hibernate.query.spi.SqmQuery;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.tree.SqmExpressibleAccessor;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.select.SqmJpaCompoundSelection;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelection;
import org.hibernate.tool.language.spi.ResultsSerializer;
import org.hibernate.type.descriptor.jdbc.spi.DescriptiveJsonGeneratingVisitor;
import org.hibernate.type.format.JsonDocumentWriter;
import org.hibernate.type.format.StringJsonDocumentWriter;

public class ResultsJsonSerializerImpl
implements ResultsSerializer {
    private static final DescriptiveJsonGeneratingVisitor JSON_VISITOR = new DescriptiveJsonGeneratingVisitor();
    private final SessionFactoryImplementor factory;

    public ResultsJsonSerializerImpl(SessionFactoryImplementor factory) {
        this.factory = factory;
    }

    @Override
    public <T> String toString(List<? extends T> values, SelectionQuery<T> query) throws IOException {
        if (values.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        StringJsonDocumentWriter writer = new StringJsonDocumentWriter(sb);
        int separator = 91;
        for (T value : values) {
            sb.append((char)separator);
            this.renderValue(value, (SqmQuery)query, writer);
            separator = 44;
        }
        sb.append(']');
        return sb.toString();
    }

    private <T> void renderValue(T value, SqmQuery<? super T> query, StringJsonDocumentWriter writer) throws IOException {
        SqmStatement sqm = query.getSqmStatement();
        if (!(sqm instanceof SqmSelectStatement)) {
            throw new IllegalArgumentException("Query is not a select statement.");
        }
        SqmSelectStatement sqmSelect = (SqmSelectStatement)sqm;
        List selections = sqmSelect.getQuerySpec().getSelectClause().getSelections();
        assert (!selections.isEmpty());
        if (selections.size() == 1) {
            this.renderValue((Object)value, (Selection<?>)((SqmSelection)selections.get(0)).getSelectableNode(), writer);
        } else {
            writer.startArray();
            for (int i = 0; i < selections.size(); ++i) {
                SqmSelection selection = (SqmSelection)selections.get(i);
                if (value instanceof Object[]) {
                    Object[] array = (Object[])value;
                    this.renderValue(array[i], (Selection<?>)selection.getSelectableNode(), writer);
                    continue;
                }
                if (value instanceof Tuple) {
                    Tuple tuple = (Tuple)value;
                    this.renderValue(tuple.get(i), (Selection<?>)selection.getSelectableNode(), writer);
                    continue;
                }
                this.renderValue((Object)value, (Selection<?>)selection.getSelectableNode(), writer);
            }
            writer.endArray();
        }
    }

    private void renderValue(Object value, Selection<?> selection, StringJsonDocumentWriter writer) throws IOException {
        if (selection instanceof SqmRoot) {
            SqmRoot root = (SqmRoot)selection;
            EntityPersister persister = this.factory.getMappingMetamodel().getEntityDescriptor(root.getEntityName());
            JSON_VISITOR.visit((MappingType)persister.getEntityMappingType(), value, this.factory.getWrapperOptions(), (JsonDocumentWriter)writer);
        } else if (selection instanceof SqmPath) {
            SqmPath path = (SqmPath)selection;
            ValuedModelPart subPart = this.getSubPart(path.getLhs(), path.getNavigablePath().getLocalName());
            if (subPart != null) {
                JSON_VISITOR.visit(subPart.getMappedType(), value, this.factory.getWrapperOptions(), (JsonDocumentWriter)writer);
            } else {
                ResultsJsonSerializerImpl.expressibleToString(path, value, writer);
            }
        } else if (selection instanceof SqmJpaCompoundSelection) {
            SqmJpaCompoundSelection compoundSelection = (SqmJpaCompoundSelection)selection;
            List compoundSelectionItems = compoundSelection.getCompoundSelectionItems();
            assert (compoundSelectionItems.size() > 1);
            writer.startArray();
            for (int j = 0; j < compoundSelectionItems.size(); ++j) {
                this.renderValue(ResultsJsonSerializerImpl.getValue(value, j), (Selection)compoundSelectionItems.get(j), writer);
            }
            writer.endArray();
        } else if (selection instanceof SqmExpressibleAccessor) {
            SqmExpressibleAccessor node = (SqmExpressibleAccessor)selection;
            ResultsJsonSerializerImpl.expressibleToString(node, value, writer);
        } else {
            writer.stringValue(String.valueOf(value));
        }
    }

    private static void expressibleToString(SqmExpressibleAccessor<?> node, Object value, StringJsonDocumentWriter writer) {
        String result;
        SqmBindableType expressible = node.getExpressible();
        String string = result = expressible != null ? expressible.getExpressibleJavaType().toString(value) : value.toString();
        if (value instanceof Boolean) {
            Boolean boolValue = (Boolean)value;
            writer.booleanValue(boolValue.booleanValue());
        } else if (value instanceof Number) {
            Number numValue = (Number)value;
            writer.numericValue(numValue);
        } else if (result == null) {
            writer.nullValue();
        } else {
            writer.stringValue(result);
        }
    }

    private static Object getValue(Object value, int index) {
        if (value.getClass().isArray()) {
            return ((Object[])value)[index];
        }
        if (value instanceof Tuple) {
            Tuple tuple = (Tuple)value;
            return tuple.get(index);
        }
        if (index > 0) {
            throw new IllegalArgumentException("Index out of range: " + index);
        }
        return value;
    }

    private ValuedModelPart getSubPart(SqmPath<?> path, String propertyName) {
        if (path instanceof SqmRoot) {
            SqmRoot root = (SqmRoot)path;
            EntityPersister entityDescriptor = this.factory.getMappingMetamodel().getEntityDescriptor(root.getEntityName());
            return entityDescriptor.findAttributeMapping(propertyName);
        }
        ValuedModelPart subPart = this.getSubPart(path.getLhs(), path.getNavigablePath().getLocalName());
        if (subPart instanceof EmbeddableValuedModelPart) {
            EmbeddableValuedModelPart embeddable = (EmbeddableValuedModelPart)subPart;
            return embeddable.getEmbeddableTypeDescriptor().findAttributeMapping(propertyName);
        }
        if (subPart instanceof EntityValuedModelPart) {
            EntityValuedModelPart entity = (EntityValuedModelPart)subPart;
            return entity.getEntityMappingType().findAttributeMapping(propertyName);
        }
        if (subPart instanceof PluralAttributeMapping) {
            PluralAttributeMapping plural = (PluralAttributeMapping)subPart;
            CollectionPart.Nature nature = (CollectionPart.Nature)NullnessUtil.castNonNull((Object)CollectionPart.Nature.fromNameExact((String)propertyName));
            return switch (nature) {
                default -> throw new IncompatibleClassChangeError();
                case CollectionPart.Nature.ELEMENT -> plural.getElementDescriptor();
                case CollectionPart.Nature.ID -> plural.getIdentifierDescriptor();
                case CollectionPart.Nature.INDEX -> plural.getIndexDescriptor();
            };
        }
        return null;
    }
}

