/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.search.query.spi;

import jakarta.persistence.QueryTimeoutException;
import java.util.function.Function;
import org.hibernate.ScrollableResults;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.search.engine.search.query.SearchScroll;
import org.hibernate.search.engine.search.query.SearchScrollResult;
import org.hibernate.search.mapper.orm.logging.impl.OrmMiscLog;
import org.hibernate.search.util.common.SearchTimeoutException;

public class HibernateOrmSearchScrollableResultsAdapter<R, H>
implements ScrollableResults<R>,
ScrollableResultsImplementor<R> {
    private final SearchScroll<H> scroll;
    private final int maxResults;
    private final Function<? super H, ? extends R> hitExtractor;
    private SearchScrollResult<H> currentChunk;
    private H currentHit;
    private int currentIndexInScroll;
    private int currentIndexInCurrentChunk;
    private boolean afterLast;
    private boolean closed;

    public HibernateOrmSearchScrollableResultsAdapter(SearchScroll<H> scroll, int maxResults, Function<? super H, ? extends R> hitExtractor) {
        this.scroll = scroll;
        this.maxResults = maxResults;
        this.hitExtractor = hitExtractor;
        this.currentChunk = null;
        this.currentHit = null;
        this.currentIndexInScroll = -1;
        this.currentIndexInCurrentChunk = -1;
        this.afterLast = false;
        this.closed = false;
    }

    public boolean next() {
        this.checkNotClosed();
        return this.scroll(1);
    }

    public boolean previous() {
        this.checkNotClosed();
        throw OrmMiscLog.INSTANCE.cannotScrollBackwards();
    }

    public boolean scroll(int positions) {
        this.checkNotClosed();
        if (positions < 0) {
            throw OrmMiscLog.INSTANCE.cannotScrollBackwards();
        }
        if (this.afterLast) {
            return false;
        }
        if (positions == 0) {
            return this.currentIndexInScroll >= 0;
        }
        this.currentIndexInScroll += positions;
        this.currentIndexInCurrentChunk += positions;
        if (this.currentIndexInScroll >= this.maxResults) {
            this.afterLast();
            return false;
        }
        if (this.currentChunk == null) {
            this.currentChunk = this.nextChunk();
        }
        int currentChunkSize = this.currentChunk.hits().size();
        while (this.currentIndexInCurrentChunk >= currentChunkSize && this.currentChunk.hasHits()) {
            this.currentIndexInCurrentChunk -= currentChunkSize;
            this.currentChunk = this.nextChunk();
            currentChunkSize = this.currentChunk.hits().size();
        }
        if (this.currentIndexInCurrentChunk >= this.currentChunk.hits().size()) {
            this.afterLast();
            return false;
        }
        this.currentHit = this.currentChunk.hits().get(this.currentIndexInCurrentChunk);
        if (this.currentIndexInCurrentChunk == currentChunkSize - 1) {
            this.currentChunk = this.nextChunk();
            this.currentIndexInCurrentChunk = -1;
        }
        return true;
    }

    public boolean last() {
        this.checkNotClosed();
        if (this.afterLast) {
            throw OrmMiscLog.INSTANCE.cannotScrollBackwards();
        }
        while (!this.isLast() && !this.afterLast) {
            this.next();
        }
        return this.isLast();
    }

    public boolean first() {
        this.checkNotClosed();
        if (this.currentIndexInScroll == 0) {
            return true;
        }
        if (this.currentIndexInScroll != -1) {
            throw OrmMiscLog.INSTANCE.cannotScrollBackwards();
        }
        return this.scroll(1);
    }

    public void beforeFirst() {
        this.checkNotClosed();
        if (this.currentIndexInScroll != -1) {
            throw OrmMiscLog.INSTANCE.cannotScrollBackwards();
        }
    }

    public void afterLast() {
        this.checkNotClosed();
        this.currentChunk = null;
        this.currentHit = null;
        this.currentIndexInScroll = Integer.MAX_VALUE;
        this.currentIndexInCurrentChunk = -1;
        this.afterLast = true;
    }

    public boolean isFirst() {
        return !this.afterLast && this.currentIndexInScroll == 0;
    }

    public boolean isLast() {
        return !this.afterLast && (this.currentIndexInScroll == this.maxResults - 1 || this.currentChunk != null && !this.currentChunk.hasHits());
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.scroll.close();
        }
        catch (RuntimeException e) {
            OrmMiscLog.INSTANCE.unableToCloseSearcherInScrollableResult(e);
        }
    }

    @Deprecated(since="8.0", forRemoval=true)
    public int getRowNumber() {
        if (this.afterLast) {
            return -1;
        }
        return this.currentIndexInScroll;
    }

    public boolean position(int position) {
        return this.setRowNumber(position - 1);
    }

    public int getPosition() {
        if (this.afterLast) {
            return -1;
        }
        return this.currentIndexInScroll + 1;
    }

    @Deprecated(since="8.0", forRemoval=true)
    public boolean setRowNumber(int rowNumber) {
        this.checkNotClosed();
        if (rowNumber < 0) {
            throw OrmMiscLog.INSTANCE.cannotSetScrollPositionRelativeToEnd();
        }
        return this.scroll(rowNumber - this.currentIndexInScroll);
    }

    public void setFetchSize(int i) {
        throw OrmMiscLog.INSTANCE.cannotSetFetchSize();
    }

    public boolean isClosed() {
        return this.closed;
    }

    public R get() {
        this.checkNotClosed();
        if (this.currentIndexInScroll < 0 || this.afterLast) {
            return null;
        }
        return this.hitExtractor.apply(this.currentHit);
    }

    private SearchScrollResult<H> nextChunk() {
        try {
            return this.scroll.next();
        }
        catch (SearchTimeoutException e) {
            throw new QueryTimeoutException((Throwable)e);
        }
    }

    private void checkNotClosed() {
        if (this.closed) {
            throw OrmMiscLog.INSTANCE.cannotUseClosedScrollableResults();
        }
    }
}

