/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.mapping.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.search.mapper.orm.automaticindexing.impl.AutomaticIndexingTypeContextProvider;
import org.hibernate.search.mapper.orm.event.impl.HibernateOrmListenerTypeContextProvider;
import org.hibernate.search.mapper.orm.logging.impl.MappingLog;
import org.hibernate.search.mapper.orm.mapping.impl.AbstractHibernateOrmTypeContext;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmContainedTypeContext;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmIndexedTypeContext;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBasicTypeMetadataProvider;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSessionTypeContextProvider;
import org.hibernate.search.mapper.orm.spi.BatchTypeContextProvider;
import org.hibernate.search.mapper.pojo.loading.spi.PojoLoadingTypeContextProvider;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.util.common.data.spi.KeyValueProvider;

class HibernateOrmTypeContextContainer
implements HibernateOrmListenerTypeContextProvider,
HibernateOrmSessionTypeContextProvider,
AutomaticIndexingTypeContextProvider,
BatchTypeContextProvider {
    private final KeyValueProvider<PojoRawTypeIdentifier<?>, HibernateOrmIndexedTypeContext<?>> indexedByTypeIdentifier;
    private final KeyValueProvider<Class<?>, AbstractHibernateOrmTypeContext<?>> byExactClass;
    private final KeyValueProvider<Class<?>, HibernateOrmIndexedTypeContext<?>> indexedByExactClass;
    private final KeyValueProvider<String, AbstractHibernateOrmTypeContext<?>> byEntityName;
    private final KeyValueProvider<String, HibernateOrmIndexedTypeContext<?>> indexedByEntityName;
    private final KeyValueProvider<String, AbstractHibernateOrmTypeContext<?>> byHibernateOrmEntityName;

    private HibernateOrmTypeContextContainer(Builder builder, PojoLoadingTypeContextProvider delegate, SessionFactoryImplementor sessionFactory) {
        PojoRawTypeIdentifier typeIdentifier;
        AbstractHibernateOrmTypeContext typeContext;
        LinkedHashMap indexedByTypeIdentifierContent = new LinkedHashMap();
        LinkedHashMap<Class, AbstractHibernateOrmTypeContext> byExactClassContent = new LinkedHashMap<Class, AbstractHibernateOrmTypeContext>();
        LinkedHashMap<Class, AbstractHibernateOrmTypeContext> indexedByExactClassContent = new LinkedHashMap<Class, AbstractHibernateOrmTypeContext>();
        LinkedHashMap<String, AbstractHibernateOrmTypeContext> byEntityNameContent = new LinkedHashMap<String, AbstractHibernateOrmTypeContext>();
        LinkedHashMap<String, AbstractHibernateOrmTypeContext> indexedByEntityNameContent = new LinkedHashMap<String, AbstractHibernateOrmTypeContext>();
        LinkedHashMap<String, AbstractHibernateOrmTypeContext> byHibernateOrmEntityNameContent = new LinkedHashMap<String, AbstractHibernateOrmTypeContext>();
        for (HibernateOrmIndexedTypeContext.Builder<?> builder2 : builder.indexed) {
            typeContext = builder2.build(delegate, sessionFactory);
            typeIdentifier = typeContext.typeIdentifier();
            indexedByTypeIdentifierContent.put(typeIdentifier, (HibernateOrmIndexedTypeContext<?>)typeContext);
            if (!typeIdentifier.isNamed()) {
                byExactClassContent.put(typeIdentifier.javaClass(), typeContext);
                indexedByExactClassContent.put(typeIdentifier.javaClass(), typeContext);
            }
            byEntityNameContent.put(typeContext.jpaEntityName(), typeContext);
            indexedByEntityNameContent.put(typeContext.jpaEntityName(), typeContext);
            byEntityNameContent.putIfAbsent(typeContext.hibernateOrmEntityName(), typeContext);
            indexedByEntityNameContent.putIfAbsent(typeContext.hibernateOrmEntityName(), typeContext);
            byHibernateOrmEntityNameContent.put(typeContext.hibernateOrmEntityName(), typeContext);
        }
        for (HibernateOrmContainedTypeContext.Builder builder3 : builder.contained) {
            typeContext = builder3.build(delegate, sessionFactory);
            typeIdentifier = typeContext.typeIdentifier();
            if (!typeIdentifier.isNamed()) {
                byExactClassContent.put(typeIdentifier.javaClass(), typeContext);
            }
            byEntityNameContent.put(typeContext.jpaEntityName(), typeContext);
            byEntityNameContent.putIfAbsent(typeContext.hibernateOrmEntityName(), typeContext);
            byHibernateOrmEntityNameContent.put(typeContext.hibernateOrmEntityName(), typeContext);
        }
        this.indexedByTypeIdentifier = new KeyValueProvider(indexedByTypeIdentifierContent, MappingLog.INSTANCE::unknownTypeIdentifierForIndexedEntityType);
        this.byExactClass = new KeyValueProvider(byExactClassContent, MappingLog.INSTANCE::unknownClassForMappedEntityType);
        this.indexedByExactClass = new KeyValueProvider(indexedByExactClassContent, MappingLog.INSTANCE::unknownClassForIndexedEntityType);
        this.byEntityName = new KeyValueProvider(byEntityNameContent, MappingLog.INSTANCE::unknownEntityNameForMappedEntityType);
        this.indexedByEntityName = new KeyValueProvider(indexedByEntityNameContent, MappingLog.INSTANCE::unknownEntityNameForIndexedEntityType);
        this.byHibernateOrmEntityName = new KeyValueProvider(byHibernateOrmEntityNameContent, MappingLog.INSTANCE::unknownHibernateOrmEntityNameForMappedEntityType);
    }

    public <E> HibernateOrmIndexedTypeContext<E> indexedForExactType(PojoRawTypeIdentifier<E> typeIdentifier) {
        return (HibernateOrmIndexedTypeContext)this.indexedByTypeIdentifier.getOrFail(typeIdentifier);
    }

    public <E> AbstractHibernateOrmTypeContext<E> forExactClass(Class<E> typeIdentifier) {
        return (AbstractHibernateOrmTypeContext)this.byExactClass.getOrFail(typeIdentifier);
    }

    public <E> HibernateOrmIndexedTypeContext<E> indexedForExactClass(Class<E> typeIdentifier) {
        return (HibernateOrmIndexedTypeContext)this.indexedByExactClass.getOrFail(typeIdentifier);
    }

    public KeyValueProvider<String, AbstractHibernateOrmTypeContext<?>> byEntityName() {
        return this.byEntityName;
    }

    public KeyValueProvider<String, HibernateOrmIndexedTypeContext<?>> indexedByEntityName() {
        return this.indexedByEntityName;
    }

    public KeyValueProvider<String, AbstractHibernateOrmTypeContext<?>> byHibernateOrmEntityName() {
        return this.byHibernateOrmEntityName;
    }

    Collection<? extends HibernateOrmIndexedTypeContext<?>> allIndexed() {
        return this.indexedByTypeIdentifier.values();
    }

    static class Builder {
        private final HibernateOrmBasicTypeMetadataProvider basicTypeMetadataProvider;
        public final List<HibernateOrmIndexedTypeContext.Builder<?>> indexed = new ArrayList();
        public final List<HibernateOrmContainedTypeContext.Builder<?>> contained = new ArrayList();

        Builder(HibernateOrmBasicTypeMetadataProvider basicTypeMetadataProvider) {
            this.basicTypeMetadataProvider = basicTypeMetadataProvider;
        }

        <E> HibernateOrmIndexedTypeContext.Builder<E> addIndexed(PojoRawTypeModel<E> typeModel, String jpaEntityName) {
            String hibernateOrmEntityName = this.basicTypeMetadataProvider.getHibernateOrmEntityNameByJpaEntityName(jpaEntityName);
            HibernateOrmIndexedTypeContext.Builder<E> builder = new HibernateOrmIndexedTypeContext.Builder<E>(typeModel, this.basicTypeMetadataProvider.getPersistentClass(hibernateOrmEntityName));
            this.indexed.add(builder);
            return builder;
        }

        <E> HibernateOrmContainedTypeContext.Builder<E> addContained(PojoRawTypeModel<E> typeModel, String jpaEntityName) {
            String hibernateOrmEntityName = this.basicTypeMetadataProvider.getHibernateOrmEntityNameByJpaEntityName(jpaEntityName);
            HibernateOrmContainedTypeContext.Builder<E> builder = new HibernateOrmContainedTypeContext.Builder<E>(typeModel, this.basicTypeMetadataProvider.getPersistentClass(hibernateOrmEntityName));
            this.contained.add(builder);
            return builder;
        }

        HibernateOrmTypeContextContainer build(PojoLoadingTypeContextProvider delegate, SessionFactoryImplementor sessionFactory) {
            return new HibernateOrmTypeContextContainer(this, delegate, sessionFactory);
        }
    }
}

