package org.hibernate.search.mapper.orm.logging.impl;

import java.util.Locale;
import java.io.Serializable;
import org.hibernate.Transaction;
import org.hibernate.search.util.common.SearchException;
import java.lang.Throwable;
import java.util.List;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.TRACE;

/**
 * Warning this class consists of generated code.
 */
public class IndexingLog_$logger implements IndexingLog, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = IndexingLog_$logger.class.getName();
    public IndexingLog_$logger(final Logger log) {
        this.log = log;
    }
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String indexingFailure$str() {
        return "HSEARCH800022: Indexing failure: %1$s.\nThe following entities may not have been updated correctly in the index: %2$s.";
    }
    @Override
    public final SearchException indexingFailure(final String causeMessage, final List<?> failingEntities, final Throwable cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), indexingFailure$str(), causeMessage, failingEntities), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    @Override
    public final void beforeCompletion(final Transaction transactionIdentifier) {
        log.logf(FQCN, TRACE, null, beforeCompletion$str(), transactionIdentifier);
    }
    protected String beforeCompletion$str() {
        return "HSEARCH800135: Processing Transaction's beforeCompletion() phase for %s.";
    }
    @Override
    public final void afterCompletionExecuting(final Transaction transactionIdentifier) {
        log.logf(FQCN, TRACE, null, afterCompletionExecuting$str(), transactionIdentifier);
    }
    protected String afterCompletionExecuting$str() {
        return "HSEARCH800136: Processing Transaction's afterCompletion() phase for %s. Executing indexing plan.";
    }
    @Override
    public final void afterCompletionCanceling(final Transaction transactionIdentifier, final int status) {
        log.logf(FQCN, TRACE, null, afterCompletionCanceling$str(), transactionIdentifier, status);
    }
    protected String afterCompletionCanceling$str() {
        return "HSEARCH800137: Processing Transaction's afterCompletion() phase for %s. Cancelling indexing plan due to transaction status %d";
    }
}
