/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.session.impl;

import jakarta.transaction.Synchronization;
import org.hibernate.Transaction;
import org.hibernate.search.mapper.orm.logging.impl.IndexingLog;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSearchSessionHolder;
import org.hibernate.search.mapper.pojo.work.spi.ConfiguredIndexingPlanSynchronizationStrategy;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingPlan;

class AfterCommitIndexingPlanSynchronization
implements Synchronization {
    private final PojoIndexingPlan indexingPlan;
    private final HibernateOrmSearchSessionHolder sessionHolder;
    private final Transaction transactionIdentifier;
    private final ConfiguredIndexingPlanSynchronizationStrategy synchronizationStrategy;

    AfterCommitIndexingPlanSynchronization(PojoIndexingPlan indexingPlan, HibernateOrmSearchSessionHolder sessionHolder, Transaction transactionIdentifier, ConfiguredIndexingPlanSynchronizationStrategy synchronizationStrategy) {
        this.indexingPlan = indexingPlan;
        this.sessionHolder = sessionHolder;
        this.transactionIdentifier = transactionIdentifier;
        this.synchronizationStrategy = synchronizationStrategy;
    }

    public void beforeCompletion() {
        IndexingLog.INSTANCE.beforeCompletion(this.transactionIdentifier);
        this.indexingPlan.process();
    }

    public void afterCompletion(int i) {
        try {
            if (3 == i) {
                IndexingLog.INSTANCE.afterCompletionExecuting(this.transactionIdentifier);
                this.synchronizationStrategy.executeAndSynchronize(this.indexingPlan);
            } else {
                IndexingLog.INSTANCE.afterCompletionCanceling(this.transactionIdentifier, i);
                this.indexingPlan.discard();
            }
        }
        finally {
            this.sessionHolder.clear(this.transactionIdentifier);
        }
    }
}

