/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.logging.impl;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Set;
import org.hibernate.resource.beans.container.spi.BeanContainer;
import org.hibernate.search.engine.environment.bean.spi.BeanNotFoundException;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.CategorizedLogger;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@CategorizedLogger(category="org.hibernate.search.configuration.mapper.orm", description="Logs related to Hibernate ORM mapper-specific configuration.\n")
@MessageLogger(projectCode="HSEARCH")
public interface ConfigurationLog {
    public static final String CATEGORY_NAME = "org.hibernate.search.configuration.mapper.orm";
    public static final ConfigurationLog INSTANCE = (ConfigurationLog)LoggerFactory.make(ConfigurationLog.class, (String)"org.hibernate.search.configuration.mapper.orm", (MethodHandles.Lookup)MethodHandles.lookup());

    @Message(id=800001, value="Hibernate Search was not initialized.")
    public SearchException hibernateSearchNotInitialized();

    @Message(id=800003, value="Invalid automatic indexing strategy name: '%1$s'. Valid names are: %2$s.")
    public SearchException invalidAutomaticIndexingStrategyName(String var1, List<String> var2);

    @Message(id=800018, value="Invalid entity loading cache lookup strategy name: '%1$s'. Valid names are: %2$s.")
    public SearchException invalidEntityLoadingCacheLookupStrategyName(String var1, List<String> var2);

    @Message(id=800032, value="Invalid schema management strategy name: '%1$s'. Valid names are: %2$s.")
    public SearchException invalidSchemaManagementStrategyName(String var1, List<String> var2);

    @Message(id=800041, value="No such bean in bean container '%1$s'.")
    public BeanNotFoundException beanNotFoundInBeanContainer(BeanContainer var1);

    @Message(id=800042, value="Cannot customize the indexing plan synchronization strategy:  the selected coordination strategy always processes events asynchronously, through a queue.")
    public SearchException cannotConfigureSynchronizationStrategyWithIndexingEventQueue();

    @Message(id=800054, value="Cannot determine the set of all possible tenant identifiers. You must provide this information by setting configuration property '%1$s' to a comma-separated string containing all possible tenant identifiers.")
    public SearchException missingTenantIdConfiguration(String var1);

    @Message(id=800055, value="Cannot target tenant '%1$s' because this tenant identifier was not listed in the configuration provided on startup. To target this tenant, you must provide the tenant identifier through configuration property '%3$s', which should be set to a comma-separated string containing all possible tenant identifiers. Currently configured tenant identifiers: %2$s.")
    public SearchException invalidTenantId(String var1, Set<String> var2, String var3);

    @Message(id=800124, value="Unable to apply the given filter at the session level with the outbox polling coordination strategy. With this coordination strategy, applying a session-level indexing plan filter is only allowed if it excludes all types.")
    public SearchException cannotApplySessionFilterWhenAsyncProcessingIsUsed();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=800138, value="Error resolving bean of type [%s] - using fallback")
    public void errorResolvingBean(Class<?> var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=800139, value="Hibernate Search is disabled through configuration properties.")
    public void hibernateSearchDisabled();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=800140, value="Hibernate Search dirty checks: %s")
    public void dirtyChecksEnabled(boolean var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=800141, value="Hibernate Search event listeners activated")
    public void hibernateSearchListenerEnabled();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=800142, value="Hibernate Search event listeners deactivated")
    public void hibernateSearchListenerDisabled();
}

