/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.loading.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Hibernate;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.query.Query;
import org.hibernate.search.mapper.orm.loading.impl.AbstractHibernateOrmSelectionEntityLoader;
import org.hibernate.search.mapper.orm.loading.impl.TypeQueryFactory;
import org.hibernate.search.mapper.orm.loading.spi.HibernateOrmLoadingSessionContext;
import org.hibernate.search.mapper.orm.loading.spi.MutableEntityLoadingOptions;
import org.hibernate.search.mapper.orm.logging.impl.LoadingLog;
import org.hibernate.search.mapper.pojo.loading.spi.PojoLoadingTypeContext;
import org.hibernate.search.util.common.impl.CollectionHelper;
import org.hibernate.search.util.common.reflect.spi.ValueReadHandle;

class HibernateOrmSelectionEntityByNonIdPropertyLoader<E>
extends AbstractHibernateOrmSelectionEntityLoader<E> {
    private final PojoLoadingTypeContext<E> targetEntityTypeContext;
    private final String documentIdSourcePropertyName;
    private final ValueReadHandle<?> documentIdSourceHandle;

    HibernateOrmSelectionEntityByNonIdPropertyLoader(EntityMappingType entityMappingType, PojoLoadingTypeContext<E> targetEntityTypeContext, TypeQueryFactory<E, ?> queryFactory, String documentIdSourcePropertyName, ValueReadHandle<?> documentIdSourceHandle, HibernateOrmLoadingSessionContext sessionContext, MutableEntityLoadingOptions loadingOptions) {
        super(entityMappingType, queryFactory, sessionContext, loadingOptions);
        this.targetEntityTypeContext = targetEntityTypeContext;
        this.documentIdSourcePropertyName = documentIdSourcePropertyName;
        this.documentIdSourceHandle = documentIdSourceHandle;
    }

    @Override
    protected List<E> doLoadEntities(List<?> allIds, Long timeout) {
        HashMap entityById = CollectionHelper.newHashMap((int)allIds.size());
        int fetchSize = this.loadingOptions.fetchSize();
        Query query = this.createQuery(fetchSize, timeout);
        ArrayList ids = new ArrayList(fetchSize);
        for (Object documentIdSourceValue : allIds) {
            ids.add(documentIdSourceValue);
            if (ids.size() < fetchSize) continue;
            query.setParameterList("ids", ids);
            this.addResults(entityById, query.getResultList());
            ids.clear();
        }
        if (!ids.isEmpty()) {
            query.setParameterList("ids", ids);
            this.addResults(entityById, query.getResultList());
        }
        ArrayList result = new ArrayList(allIds.size());
        for (Object identifier : allIds) {
            result.add(entityById.get(identifier));
        }
        return result;
    }

    private void addResults(Map<Object, E> resultMap, List<? extends E> loadedEntities) {
        for (E loadedEntity : loadedEntities) {
            Object unproxied = Hibernate.unproxy(loadedEntity);
            Object documentIdSourceValue = this.documentIdSourceHandle.get(unproxied);
            E previous = resultMap.put(documentIdSourceValue, loadedEntity);
            if (previous == null) continue;
            throw LoadingLog.INSTANCE.foundMultipleEntitiesForDocumentId(this.targetEntityTypeContext.entityName(), this.documentIdSourcePropertyName, documentIdSourceValue);
        }
    }
}

