/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.bootstrap.impl;

import org.hibernate.resource.beans.container.spi.BeanContainer;
import org.hibernate.resource.beans.container.spi.ContainedBean;
import org.hibernate.resource.beans.spi.BeanInstanceProducer;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.spi.BeanProvider;
import org.hibernate.search.mapper.orm.bootstrap.impl.HibernateOrmContainedBeanBeanHolderAdapter;
import org.hibernate.search.mapper.orm.logging.impl.ConfigurationLog;
import org.hibernate.search.util.common.impl.Contracts;
import org.hibernate.search.util.common.impl.SuppressingCloser;

final class HibernateOrmBeanContainerBeanProvider
implements BeanProvider {
    private static final BeanContainer.LifecycleOptions LIFECYCLE_OPTIONS = new BeanContainer.LifecycleOptions(){

        public boolean canUseCachedReferences() {
            return false;
        }

        public boolean useJpaCompliantCreation() {
            return false;
        }
    };
    private final BeanContainer beanContainer;
    private final BeanInstanceProducer fallbackInstanceProducer;

    HibernateOrmBeanContainerBeanProvider(final BeanContainer beanContainer) {
        Contracts.assertNotNull((Object)beanContainer, (String)"beanContainer");
        this.beanContainer = beanContainer;
        this.fallbackInstanceProducer = new BeanInstanceProducer(){

            public <B> B produceBeanInstance(Class<B> aClass) {
                throw ConfigurationLog.INSTANCE.beanNotFoundInBeanContainer(beanContainer);
            }

            public <B> B produceBeanInstance(String s, Class<B> aClass) {
                throw ConfigurationLog.INSTANCE.beanNotFoundInBeanContainer(beanContainer);
            }
        };
    }

    public void close() {
    }

    public <T> BeanHolder<T> forType(Class<T> typeReference) {
        ContainedBean containedBean = this.beanContainer.getBean(typeReference, LIFECYCLE_OPTIONS, this.fallbackInstanceProducer);
        BeanHolder result = new HibernateOrmContainedBeanBeanHolderAdapter(containedBean);
        try {
            result.get();
        }
        catch (Exception e) {
            new SuppressingCloser((Throwable)e).push(result);
            ConfigurationLog.INSTANCE.errorResolvingBean(typeReference, e);
            try {
                result = BeanHolder.of((Object)this.fallbackInstanceProducer.produceBeanInstance(typeReference));
            }
            catch (Exception e2) {
                e2.addSuppressed(e);
                throw e2;
            }
        }
        return result;
    }

    public <T> BeanHolder<T> forTypeAndName(Class<T> typeReference, String nameReference) {
        ContainedBean containedBean = this.beanContainer.getBean(nameReference, typeReference, LIFECYCLE_OPTIONS, this.fallbackInstanceProducer);
        HibernateOrmContainedBeanBeanHolderAdapter result = new HibernateOrmContainedBeanBeanHolderAdapter(containedBean);
        result.get();
        return result;
    }
}

