/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.work.impl;

import org.hibernate.search.mapper.orm.work.SearchIndexingPlan;
import org.hibernate.search.mapper.orm.work.impl.SearchIndexingPlanSessionContext;
import org.hibernate.search.mapper.orm.work.impl.SearchIndexingPlanTypeContextProvider;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeContext;
import org.hibernate.search.mapper.pojo.route.DocumentRoutesDescriptor;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingPlan;
import org.hibernate.search.mapper.pojo.work.spi.PojoTypeIndexingPlan;

public final class SearchIndexingPlanImpl
implements SearchIndexingPlan {
    private final SearchIndexingPlanTypeContextProvider typeContextProvider;
    private final SearchIndexingPlanSessionContext sessionContext;

    public SearchIndexingPlanImpl(SearchIndexingPlanTypeContextProvider typeContextProvider, SearchIndexingPlanSessionContext sessionContext) {
        this.typeContextProvider = typeContextProvider;
        this.sessionContext = sessionContext;
    }

    @Override
    public void addOrUpdate(Object entity) {
        PojoTypeIndexingPlan typeDelegate = this.delegate(true).typeIfIncludedOrNull(this.getTypeIdentifier(entity));
        if (typeDelegate == null) {
            return;
        }
        typeDelegate.addOrUpdate(null, null, entity, true, true, null);
    }

    @Override
    public void delete(Object entity) {
        PojoTypeIndexingPlan typeDelegate = this.delegate(true).typeIfIncludedOrNull(this.getTypeIdentifier(entity));
        if (typeDelegate == null) {
            return;
        }
        typeDelegate.delete(null, null, entity);
    }

    @Override
    public void purge(Class<?> entityClass, Object providedId, String providedRoutingKey) {
        PojoTypeIndexingPlan typeDelegate = this.delegate(true).typeIfIncludedOrNull(this.getTypeIdentifier(entityClass));
        if (typeDelegate == null) {
            return;
        }
        typeDelegate.delete(providedId, DocumentRoutesDescriptor.fromLegacyRoutingKey((String)providedRoutingKey), null);
    }

    @Override
    public void purge(String entityName, Object providedId, String providedRoutingKey) {
        PojoTypeIndexingPlan typeDelegate = this.delegate(true).typeIfIncludedOrNull(this.getTypeIdentifier(entityName));
        if (typeDelegate == null) {
            return;
        }
        typeDelegate.delete(providedId, DocumentRoutesDescriptor.fromLegacyRoutingKey((String)providedRoutingKey), null);
    }

    @Override
    public void process() {
        PojoIndexingPlan plan = this.delegate(false);
        if (plan == null) {
            return;
        }
        plan.process();
    }

    @Override
    public void execute() {
        PojoIndexingPlan plan = this.delegate(false);
        if (plan == null) {
            return;
        }
        this.sessionContext.configuredAutomaticIndexingSynchronizationStrategy().executeAndSynchronize(plan);
    }

    private PojoIndexingPlan delegate(boolean createIfDoesNotExist) {
        this.sessionContext.checkOpen();
        return this.sessionContext.currentIndexingPlan(createIfDoesNotExist);
    }

    private <T> PojoRawTypeIdentifier<? extends T> getTypeIdentifier(T entity) {
        return this.sessionContext.runtimeIntrospector().detectEntityType(entity);
    }

    private PojoRawTypeIdentifier<?> getTypeIdentifier(Class<?> entityType) {
        return this.typeContextProvider.forExactClass(entityType).typeIdentifier();
    }

    private PojoRawTypeIdentifier<?> getTypeIdentifier(String entityName) {
        return ((PojoTypeContext)this.typeContextProvider.byEntityName().getOrFail((Object)entityName)).typeIdentifier();
    }
}

