/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.bootstrap.impl;

import java.util.Map;
import java.util.Optional;
import org.hibernate.boot.ResourceStreamLocator;
import org.hibernate.boot.jaxb.mapping.JaxbEntityMappings;
import org.hibernate.boot.spi.AdditionalMappingContributions;
import org.hibernate.boot.spi.AdditionalMappingContributor;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.mapper.orm.bootstrap.impl.HibernateSearchPreIntegrationService;
import org.hibernate.search.mapper.orm.bootstrap.spi.HibernateSearchOrmMappingProducer;
import org.hibernate.search.mapper.orm.common.impl.HibernateOrmUtils;
import org.hibernate.service.ServiceRegistry;

public class HibernateSearchCompositeMappingProducer
implements AdditionalMappingContributor {
    public String getContributorName() {
        return "hibernate-search";
    }

    public void contribute(AdditionalMappingContributions contributions, InFlightMetadataCollector metadata, ResourceStreamLocator resourceStreamLocator, MetadataBuildingContext buildingContext) {
        Optional<HibernateSearchPreIntegrationService> preIntegrationServiceOptional = HibernateOrmUtils.getServiceOrEmpty((ServiceRegistry)buildingContext.getBootstrapContext().getServiceRegistry(), HibernateSearchPreIntegrationService.class);
        if (!preIntegrationServiceOptional.isPresent()) {
            return;
        }
        HibernateSearchPreIntegrationService preIntegrationService = preIntegrationServiceOptional.get();
        ConfigurationPropertySource propertySource = preIntegrationService.propertySource().withMask("coordination");
        for (HibernateSearchOrmMappingProducer mappingProducer : preIntegrationService.coordinationStrategyConfiguration().mappingProducers()) {
            for (Map.Entry<Class<?>, JaxbEntityMappings> entry : mappingProducer.produceMappings(propertySource, metadata.getDatabase().getDialect(), buildingContext).entrySet()) {
                contributions.contributeEntity(entry.getKey());
                contributions.contributeBinding(entry.getValue());
            }
        }
    }
}

