/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.loading.impl;

import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.persistence.EntityGraph;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.RootGraph;
import org.hibernate.search.mapper.orm.loading.impl.EntityGraphHint;
import org.hibernate.search.mapper.orm.loading.impl.HibernateOrmEntityLoadingStrategy;
import org.hibernate.search.mapper.orm.loading.impl.LoadingIndexedTypeContextProvider;
import org.hibernate.search.mapper.orm.loading.impl.LoadingMappingContext;
import org.hibernate.search.mapper.orm.loading.impl.LoadingSessionContext;
import org.hibernate.search.mapper.orm.loading.impl.LoadingTypeContext;
import org.hibernate.search.mapper.orm.loading.impl.MutableEntityLoadingOptions;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.search.loading.EntityLoadingCacheLookupStrategy;
import org.hibernate.search.mapper.orm.search.loading.dsl.SearchLoadingOptionsStep;
import org.hibernate.search.mapper.pojo.loading.spi.PojoLoadingTypeContext;
import org.hibernate.search.mapper.pojo.loading.spi.PojoSelectionEntityLoader;
import org.hibernate.search.mapper.pojo.loading.spi.PojoSelectionLoadingContext;
import org.hibernate.search.mapper.pojo.loading.spi.PojoSelectionLoadingContextBuilder;
import org.hibernate.search.mapper.pojo.loading.spi.PojoSelectionLoadingStrategy;
import org.hibernate.search.mapper.pojo.model.spi.PojoRuntimeIntrospector;
import org.hibernate.search.util.common.impl.Contracts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class HibernateOrmSelectionLoadingContext
implements PojoSelectionLoadingContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final LoadingIndexedTypeContextProvider typeContextProvider;
    private final LoadingSessionContext sessionContext;
    private final MutableEntityLoadingOptions loadingOptions;
    private final EntityLoadingCacheLookupStrategy cacheLookupStrategy;

    private HibernateOrmSelectionLoadingContext(Builder builder) {
        this.typeContextProvider = builder.typeContextProvider;
        this.sessionContext = builder.sessionContext;
        this.loadingOptions = builder.loadingOptions;
        this.cacheLookupStrategy = builder.cacheLookupStrategy;
    }

    public void checkOpen() {
        try {
            this.sessionContext.session().checkOpen();
        }
        catch (IllegalStateException e) {
            throw log.hibernateSessionIsClosed(e);
        }
    }

    public PojoRuntimeIntrospector runtimeIntrospector() {
        return this.sessionContext.runtimeIntrospector();
    }

    public <T> PojoSelectionLoadingStrategy<? super T> loadingStrategy(PojoLoadingTypeContext<T> type) {
        return new HibernateOrmSelectionLoadingStrategy(this.typeContextProvider.forExactType(type.typeIdentifier()).loadingStrategy());
    }

    public <T> Optional<PojoSelectionLoadingStrategy<? super T>> loadingStrategyOptional(PojoLoadingTypeContext<T> type) {
        return Optional.of(this.loadingStrategy(type));
    }

    public SessionImplementor sessionImplementor() {
        return this.sessionContext.session();
    }

    public MutableEntityLoadingOptions loadingOptions() {
        return this.loadingOptions;
    }

    public static final class Builder
    implements PojoSelectionLoadingContextBuilder<SearchLoadingOptionsStep>,
    SearchLoadingOptionsStep {
        private final LoadingIndexedTypeContextProvider typeContextProvider;
        private final LoadingSessionContext sessionContext;
        private final MutableEntityLoadingOptions loadingOptions;
        private EntityLoadingCacheLookupStrategy cacheLookupStrategy;

        public Builder(LoadingMappingContext mappingContext, LoadingIndexedTypeContextProvider typeContextProvider, LoadingSessionContext sessionContext) {
            this.typeContextProvider = typeContextProvider;
            this.sessionContext = sessionContext;
            this.loadingOptions = new MutableEntityLoadingOptions(mappingContext);
            this.cacheLookupStrategy = mappingContext.cacheLookupStrategy();
        }

        public SearchLoadingOptionsStep toAPI() {
            return this;
        }

        @Override
        public SearchLoadingOptionsStep fetchSize(int fetchSize) {
            this.loadingOptions.fetchSize(fetchSize);
            return this;
        }

        @Override
        public SearchLoadingOptionsStep cacheLookupStrategy(EntityLoadingCacheLookupStrategy strategy) {
            this.cacheLookupStrategy = strategy;
            return this;
        }

        @Override
        public SearchLoadingOptionsStep graph(EntityGraph<?> graph, GraphSemantic semantic) {
            this.loadingOptions.entityGraphHint(new EntityGraphHint((RootGraph)graph, semantic), false);
            return this;
        }

        @Override
        public SearchLoadingOptionsStep graph(String graphName, GraphSemantic semantic) {
            Contracts.assertNotNull((Object)graphName, (String)"graphName");
            return this.graph((EntityGraph<?>)this.sessionContext.session().getEntityGraph(graphName), semantic);
        }

        public PojoSelectionLoadingContext build() {
            return new HibernateOrmSelectionLoadingContext(this);
        }
    }

    private class HibernateOrmSelectionLoadingStrategy<E, I>
    implements PojoSelectionLoadingStrategy<E> {
        private final HibernateOrmEntityLoadingStrategy<E, I> delegate;

        public HibernateOrmSelectionLoadingStrategy(HibernateOrmEntityLoadingStrategy<E, I> delegate) {
            this.delegate = delegate;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HibernateOrmSelectionLoadingStrategy that = (HibernateOrmSelectionLoadingStrategy)o;
            return this.delegate.equals(that.delegate);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public PojoSelectionEntityLoader<E> createLoader(Set<? extends PojoLoadingTypeContext<? extends E>> expectedTypes) {
            HashSet typeContexts = new HashSet();
            for (PojoLoadingTypeContext<E> pojoLoadingTypeContext : expectedTypes) {
                LoadingTypeContext typeContext = HibernateOrmSelectionLoadingContext.this.typeContextProvider.forExactType(pojoLoadingTypeContext.typeIdentifier());
                typeContexts.add(typeContext);
            }
            return this.delegate.createLoader(typeContexts, HibernateOrmSelectionLoadingContext.this.sessionContext, HibernateOrmSelectionLoadingContext.this.cacheLookupStrategy, HibernateOrmSelectionLoadingContext.this.loadingOptions);
        }
    }
}

