/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.work.impl;

import org.hibernate.search.mapper.orm.work.SearchIndexingPlan;
import org.hibernate.search.mapper.orm.work.impl.SearchIndexingPlanSessionContext;
import org.hibernate.search.mapper.orm.work.impl.SearchIndexingPlanTypeContextProvider;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.route.DocumentRoutesDescriptor;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingPlan;

public final class SearchIndexingPlanImpl
implements SearchIndexingPlan {
    private final SearchIndexingPlanTypeContextProvider typeContextProvider;
    private final SearchIndexingPlanSessionContext sessionContext;

    public SearchIndexingPlanImpl(SearchIndexingPlanTypeContextProvider typeContextProvider, SearchIndexingPlanSessionContext sessionContext) {
        this.typeContextProvider = typeContextProvider;
        this.sessionContext = sessionContext;
    }

    @Override
    public void addOrUpdate(Object entity) {
        this.delegate(true).addOrUpdate(this.getTypeIdentifier(entity), null, null, entity, true, true, null);
    }

    @Override
    public void delete(Object entity) {
        this.delegate(true).delete(this.getTypeIdentifier(entity), null, null, entity);
    }

    @Override
    public void purge(Class<?> entityClass, Object providedId, String providedRoutingKey) {
        this.delegate(true).delete(this.getTypeIdentifier(entityClass), providedId, DocumentRoutesDescriptor.fromLegacyRoutingKey((String)providedRoutingKey), null);
    }

    @Override
    public void purge(String entityName, Object providedId, String providedRoutingKey) {
        this.delegate(true).delete(this.getTypeIdentifier(entityName), providedId, DocumentRoutesDescriptor.fromLegacyRoutingKey((String)providedRoutingKey), null);
    }

    @Override
    public void process() {
        PojoIndexingPlan plan = this.delegate(false);
        if (plan == null) {
            return;
        }
        plan.process();
    }

    @Override
    public void execute() {
        PojoIndexingPlan plan = this.delegate(false);
        if (plan == null) {
            return;
        }
        this.sessionContext.configuredAutomaticIndexingSynchronizationStrategy().executeAndSynchronize(plan);
    }

    private PojoIndexingPlan delegate(boolean createIfDoesNotExist) {
        this.sessionContext.checkOpen();
        return this.sessionContext.currentIndexingPlan(createIfDoesNotExist);
    }

    private <T> PojoRawTypeIdentifier<? extends T> getTypeIdentifier(T entity) {
        return this.sessionContext.runtimeIntrospector().detectEntityType(entity);
    }

    private <T> PojoRawTypeIdentifier<T> getTypeIdentifier(Class<T> entityType) {
        return this.typeContextProvider.typeIdentifierForJavaClass(entityType);
    }

    private PojoRawTypeIdentifier<?> getTypeIdentifier(String hibernateOrmEntityName) {
        return this.typeContextProvider.typeIdentifierForEntityName(hibernateOrmEntityName);
    }
}

