/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.session.impl;

import java.lang.invoke.MethodHandles;
import javax.transaction.Synchronization;
import org.hibernate.Transaction;
import org.hibernate.search.mapper.orm.automaticindexing.session.impl.ConfiguredAutomaticIndexingSynchronizationStrategy;
import org.hibernate.search.mapper.orm.common.EntityReference;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.session.impl.HibernateOrmSearchSessionHolder;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingPlan;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class PostTransactionWorkQueueSynchronization
implements Synchronization {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoIndexingPlan<EntityReference> indexingPlan;
    private final HibernateOrmSearchSessionHolder sessionHolder;
    private final Transaction transactionIdentifier;
    private final ConfiguredAutomaticIndexingSynchronizationStrategy synchronizationStrategy;

    PostTransactionWorkQueueSynchronization(PojoIndexingPlan<EntityReference> indexingPlan, HibernateOrmSearchSessionHolder sessionHolder, Transaction transactionIdentifier, ConfiguredAutomaticIndexingSynchronizationStrategy synchronizationStrategy) {
        this.indexingPlan = indexingPlan;
        this.sessionHolder = sessionHolder;
        this.transactionIdentifier = transactionIdentifier;
        this.synchronizationStrategy = synchronizationStrategy;
    }

    public void beforeCompletion() {
        log.tracef("Processing Transaction's beforeCompletion() phase: %s", this);
        this.indexingPlan.process();
    }

    public void afterCompletion(int i) {
        try {
            if (3 == i) {
                log.tracef("Processing Transaction's afterCompletion() phase for %s. Performing work.", this);
                this.synchronizationStrategy.executeAndSynchronize(this.indexingPlan);
            } else {
                log.tracef("Processing Transaction's afterCompletion() phase for %s. Cancelling work due to transaction status %d", this, i);
                this.indexingPlan.discard();
            }
        }
        finally {
            this.sessionHolder.clear(this.transactionIdentifier);
        }
    }
}

