/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.search.loading.impl;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.search.mapper.orm.search.loading.impl.EntityGraphHint;
import org.hibernate.search.mapper.orm.search.loading.impl.HibernateOrmLoadingMappingContext;
import org.hibernate.search.util.common.impl.Contracts;

public class MutableEntityLoadingOptions {
    private int fetchSize;
    private List<EntityGraphHint> entityGraphHints;

    public MutableEntityLoadingOptions(HibernateOrmLoadingMappingContext mappingContext) {
        this.fetchSize = mappingContext.fetchSize();
    }

    public int fetchSize() {
        return this.fetchSize;
    }

    public void fetchSize(int fetchSize) {
        Contracts.assertStrictlyPositive((int)fetchSize, (String)"fetchSize");
        this.fetchSize = fetchSize;
    }

    public EntityGraphHint<?> entityGraphHintOrNullForType(EntityPersister entityPersister) {
        if (this.entityGraphHints == null) {
            return null;
        }
        String hibernateOrmEntityName = entityPersister.getEntityName();
        for (EntityGraphHint entityGraphHint : this.entityGraphHints) {
            if (!entityGraphHint.graph.appliesTo(hibernateOrmEntityName)) continue;
            return entityGraphHint;
        }
        return null;
    }

    public void entityGraphHint(EntityGraphHint<?> entityGraphHint, boolean replaceExisting) {
        if (this.entityGraphHints == null) {
            this.entityGraphHints = new ArrayList<EntityGraphHint>();
        } else if (replaceExisting) {
            this.entityGraphHints.clear();
        }
        this.entityGraphHints.add(entityGraphHint);
    }
}

