/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.scope.impl;

import java.util.Set;
import org.hibernate.search.engine.backend.session.spi.DetachedBackendSessionContext;
import org.hibernate.search.engine.search.aggregation.dsl.SearchAggregationFactory;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.hibernate.search.engine.search.projection.dsl.SearchProjectionFactory;
import org.hibernate.search.engine.search.query.dsl.SearchQuerySelectStep;
import org.hibernate.search.engine.search.sort.dsl.SearchSortFactory;
import org.hibernate.search.mapper.orm.common.EntityReference;
import org.hibernate.search.mapper.orm.entity.SearchIndexedEntity;
import org.hibernate.search.mapper.orm.massindexing.MassIndexer;
import org.hibernate.search.mapper.orm.massindexing.impl.MassIndexerImpl;
import org.hibernate.search.mapper.orm.schema.management.SearchSchemaManager;
import org.hibernate.search.mapper.orm.schema.management.impl.SearchSchemaManagerImpl;
import org.hibernate.search.mapper.orm.scope.SearchScope;
import org.hibernate.search.mapper.orm.scope.impl.HibernateOrmScopeIndexedTypeContext;
import org.hibernate.search.mapper.orm.scope.impl.HibernateOrmScopeMappingContext;
import org.hibernate.search.mapper.orm.scope.impl.HibernateOrmScopeSessionContext;
import org.hibernate.search.mapper.orm.search.loading.context.impl.HibernateOrmLoadingContext;
import org.hibernate.search.mapper.orm.search.loading.dsl.SearchLoadingOptionsStep;
import org.hibernate.search.mapper.orm.search.query.dsl.impl.HibernateOrmSearchQuerySelectStep;
import org.hibernate.search.mapper.orm.work.SearchWorkspace;
import org.hibernate.search.mapper.orm.work.impl.SearchWorkspaceImpl;
import org.hibernate.search.mapper.pojo.schema.management.spi.PojoScopeSchemaManager;
import org.hibernate.search.mapper.pojo.scope.spi.PojoScopeDelegate;

public class SearchScopeImpl<E>
implements SearchScope<E> {
    private final HibernateOrmScopeMappingContext mappingContext;
    private final PojoScopeDelegate<EntityReference, E, HibernateOrmScopeIndexedTypeContext<? extends E>> delegate;

    public SearchScopeImpl(HibernateOrmScopeMappingContext mappingContext, PojoScopeDelegate<EntityReference, E, HibernateOrmScopeIndexedTypeContext<? extends E>> delegate) {
        this.mappingContext = mappingContext;
        this.delegate = delegate;
    }

    public SearchQuerySelectStep<?, EntityReference, E, SearchLoadingOptionsStep, ?, ?> search(HibernateOrmScopeSessionContext sessionContext) {
        HibernateOrmLoadingContext.Builder loadingContextBuilder = new HibernateOrmLoadingContext.Builder(this.mappingContext, sessionContext, this.delegate.includedIndexedTypes());
        return new HibernateOrmSearchQuerySelectStep(this.delegate.search(sessionContext.backendSessionContext(), loadingContextBuilder));
    }

    @Override
    public SearchPredicateFactory predicate() {
        return this.delegate.predicate();
    }

    @Override
    public SearchSortFactory sort() {
        return this.delegate.sort();
    }

    @Override
    public SearchProjectionFactory<EntityReference, E> projection() {
        return this.delegate.projection();
    }

    @Override
    public SearchAggregationFactory aggregation() {
        return this.delegate.aggregation();
    }

    @Override
    public SearchSchemaManager schemaManager() {
        return new SearchSchemaManagerImpl(this.schemaManagerDelegate());
    }

    @Override
    public SearchWorkspace workspace() {
        return this.workspace((String)null);
    }

    @Override
    public SearchWorkspace workspace(String tenantId) {
        return this.workspace(this.mappingContext.detachedBackendSessionContext(tenantId));
    }

    public SearchWorkspace workspace(DetachedBackendSessionContext detachedSessionContext) {
        return new SearchWorkspaceImpl(this.delegate.workspace(detachedSessionContext));
    }

    @Override
    public MassIndexer massIndexer() {
        return this.massIndexer((String)null);
    }

    @Override
    public MassIndexer massIndexer(String tenantId) {
        return this.massIndexer(this.mappingContext.detachedBackendSessionContext(tenantId));
    }

    public MassIndexer massIndexer(DetachedBackendSessionContext detachedSessionContext) {
        return new MassIndexerImpl(this.mappingContext, this.delegate.includedIndexedTypes(), detachedSessionContext, this.delegate.schemaManager(), this.delegate.workspace(detachedSessionContext));
    }

    @Override
    public Set<? extends SearchIndexedEntity<? extends E>> includedTypes() {
        return this.delegate.includedIndexedTypes();
    }

    public PojoScopeSchemaManager schemaManagerDelegate() {
        return this.delegate.schemaManager();
    }
}

