/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector.internal;

import java.util.List;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionArgumentException;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.domain.SqmDomainType;
import org.hibernate.type.BasicType;
import org.hibernate.type.BindingContext;

public class VectorArgumentValidator
implements ArgumentsValidator {
    public static final ArgumentsValidator INSTANCE = new VectorArgumentValidator(0);
    public static final ArgumentsValidator DISTANCE_INSTANCE = new VectorArgumentValidator(0, 1);
    private final int[] vectorIndices;

    public VectorArgumentValidator(int ... vectorIndices) {
        this.vectorIndices = vectorIndices;
    }

    public void validate(List<? extends SqmTypedNode<?>> arguments, String functionName, BindingContext bindingContext) {
        for (int i : this.vectorIndices) {
            SqmDomainType type;
            SqmBindableType expressible = arguments.get(i).getExpressible();
            if (expressible == null || (type = expressible.getSqmType()) == null || VectorArgumentValidator.isVectorType(type)) continue;
            throw new FunctionArgumentException(String.format("Parameter %d of function '%s()' requires a vector type, but argument is of type '%s'", i, functionName, type.getTypeName()));
        }
    }

    private static boolean isVectorType(SqmExpressible<?> vectorType) {
        boolean bl;
        block4: {
            block3: {
                if (!(vectorType instanceof BasicType)) break block3;
                BasicType basicType = (BasicType)vectorType;
                switch (basicType.getJdbcType().getDefaultSqlTypeCode()) {
                    case 10000: 
                    case 10001: 
                    case 10002: 
                    case 10003: 
                    case 10004: 
                    case 10005: 
                    case 10006: 
                    case 10007: 
                    case 10008: {
                        break;
                    }
                    default: {
                        break block3;
                    }
                }
                bl = true;
                break block4;
            }
            bl = false;
        }
        return bl;
    }
}

