/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector.internal;

import java.util.Arrays;
import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.tool.schema.extract.spi.ColumnTypeInformation;
import org.hibernate.type.BasicCollectionType;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractClassJavaType;
import org.hibernate.type.descriptor.java.BasicPluralJavaType;
import org.hibernate.type.descriptor.java.DoubleJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.MutableMutabilityPlan;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.vector.SparseDoubleVector;

public class SparseDoubleVectorJavaType
extends AbstractClassJavaType<SparseDoubleVector>
implements BasicPluralJavaType<Double> {
    public static final SparseDoubleVectorJavaType INSTANCE = new SparseDoubleVectorJavaType();

    public SparseDoubleVectorJavaType() {
        super(SparseDoubleVector.class, (MutabilityPlan)new SparseVectorMutabilityPlan());
    }

    public JavaType<Double> getElementJavaType() {
        return DoubleJavaType.INSTANCE;
    }

    public BasicType<?> resolveType(TypeConfiguration typeConfiguration, Dialect dialect, BasicType<Double> elementType, ColumnTypeInformation columnTypeInformation, JdbcTypeIndicators stdIndicators) {
        int arrayTypeCode = stdIndicators.getPreferredSqlTypeCodeForArray(elementType.getJdbcType().getDefaultSqlTypeCode());
        JdbcType arrayJdbcType = typeConfiguration.getJdbcTypeRegistry().resolveTypeConstructorDescriptor(arrayTypeCode, elementType, columnTypeInformation);
        if (elementType.getValueConverter() != null) {
            throw new IllegalArgumentException("Can't convert element type of sparse vector");
        }
        return typeConfiguration.getBasicTypeRegistry().resolve((JavaType)this, arrayJdbcType, () -> new BasicCollectionType(elementType, arrayJdbcType, (JavaType)this, "sparse_double_vector"));
    }

    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators indicators) {
        return indicators.getJdbcType(10006);
    }

    public <X> X unwrap(SparseDoubleVector value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (type.isInstance(value)) {
            return (X)value;
        }
        if (double[].class.isAssignableFrom(type)) {
            return (X)value.toDenseVector();
        }
        if (Object[].class.isAssignableFrom(type)) {
            return (X)value.toArray();
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)value.toString();
        }
        throw this.unknownUnwrap(type);
    }

    public <X> SparseDoubleVector wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof SparseDoubleVector) {
            SparseDoubleVector vector = (SparseDoubleVector)value;
            return vector;
        }
        if (value instanceof List) {
            List list = (List)value;
            return new SparseDoubleVector(list);
        }
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            return new SparseDoubleVector(Arrays.asList(array));
        }
        if (value instanceof double[]) {
            double[] vector = (double[])value;
            return new SparseDoubleVector(vector);
        }
        if (value instanceof String) {
            String vector = (String)value;
            return new SparseDoubleVector(vector);
        }
        throw this.unknownWrap(value.getClass());
    }

    private static class SparseVectorMutabilityPlan
    extends MutableMutabilityPlan<SparseDoubleVector> {
        private SparseVectorMutabilityPlan() {
        }

        protected SparseDoubleVector deepCopyNotNull(SparseDoubleVector value) {
            return value.clone();
        }
    }
}

