/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector.internal;

import java.lang.reflect.InvocationTargetException;
import org.hibernate.HibernateError;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.boot.model.TypeContributor;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.BasicArrayType;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.descriptor.jdbc.ArrayJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.descriptor.sql.DdlType;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.vector.internal.VectorDdlType;

public class SQLServerTypeContributor
implements TypeContributor {
    public void contribute(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        Dialect dialect = ((JdbcServices)serviceRegistry.requireService(JdbcServices.class)).getDialect();
        if (dialect instanceof SQLServerDialect && dialect.getVersion().isSameOrAfter(17)) {
            boolean supportsDriverType = SQLServerTypeContributor.supportsDriverType(serviceRegistry);
            String vectorJdbcType = supportsDriverType ? "org.hibernate.vector.internal.SQLServerVectorJdbcType" : "org.hibernate.vector.internal.SQLServerCastingVectorJdbcType";
            TypeConfiguration typeConfiguration = typeContributions.getTypeConfiguration();
            JavaTypeRegistry javaTypeRegistry = typeConfiguration.getJavaTypeRegistry();
            JdbcTypeRegistry jdbcTypeRegistry = typeConfiguration.getJdbcTypeRegistry();
            BasicTypeRegistry basicTypeRegistry = typeConfiguration.getBasicTypeRegistry();
            BasicType floatBasicType = basicTypeRegistry.resolve(StandardBasicTypes.FLOAT);
            JdbcType floatJdbcType = jdbcTypeRegistry.getDescriptor(6);
            ArrayJdbcType genericVectorJdbcType = (ArrayJdbcType)SQLServerTypeContributor.create(serviceRegistry, vectorJdbcType, floatJdbcType, 10000);
            jdbcTypeRegistry.addDescriptor(10000, (JdbcType)genericVectorJdbcType);
            ArrayJdbcType floatVectorJdbcType = (ArrayJdbcType)SQLServerTypeContributor.create(serviceRegistry, vectorJdbcType, floatJdbcType, 10002);
            jdbcTypeRegistry.addDescriptor(10002, (JdbcType)floatVectorJdbcType);
            basicTypeRegistry.register((BasicType)new BasicArrayType(floatBasicType, (JdbcType)genericVectorJdbcType, javaTypeRegistry.resolveDescriptor(float[].class)), StandardBasicTypes.VECTOR.getName());
            basicTypeRegistry.register((BasicType)new BasicArrayType(basicTypeRegistry.resolve(StandardBasicTypes.FLOAT), (JdbcType)floatVectorJdbcType, javaTypeRegistry.resolveDescriptor(float[].class)), StandardBasicTypes.VECTOR_FLOAT32.getName());
            typeConfiguration.getDdlTypeRegistry().addDescriptor((DdlType)new VectorDdlType(10000, "vector($l)", "vector", dialect));
            typeConfiguration.getDdlTypeRegistry().addDescriptor((DdlType)new VectorDdlType(10002, "vector($l)", "vector", dialect));
        }
    }

    private static boolean supportsDriverType(ServiceRegistry serviceRegistry) {
        ClassLoaderService classLoaderService = (ClassLoaderService)serviceRegistry.requireService(ClassLoaderService.class);
        try {
            classLoaderService.classForName("microsoft.sql.Vector");
            return true;
        }
        catch (ClassLoadingException ex) {
            return false;
        }
    }

    private static <X> X create(ServiceRegistry serviceRegistry, String className, JdbcType elementType, int sqlType) {
        ClassLoaderService classLoaderService = (ClassLoaderService)serviceRegistry.requireService(ClassLoaderService.class);
        try {
            return (X)classLoaderService.classForName(className).getConstructor(JdbcType.class, Integer.TYPE).newInstance(elementType, sqlType);
        }
        catch (NoSuchMethodException e) {
            throw new HibernateError("Class does not have an empty constructor", (Throwable)e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new HibernateError("Could not construct JdbcType", (Throwable)e);
        }
    }
}

