/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector.internal;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.ArrayJdbcType;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.vector.internal.PGVectorJdbcLiteralFormatterVector;
import org.hibernate.vector.internal.VectorHelper;

public class PGVectorJdbcType
extends ArrayJdbcType {
    private final int sqlType;
    private final String typeName;

    public PGVectorJdbcType(JdbcType elementJdbcType, int sqlType, String typeName) {
        super(elementJdbcType);
        this.sqlType = sqlType;
        this.typeName = typeName;
    }

    public int getDefaultSqlTypeCode() {
        return this.sqlType;
    }

    public JavaType<?> getRecommendedJavaType(Integer precision, Integer scale, TypeConfiguration typeConfiguration) {
        return typeConfiguration.getJavaTypeRegistry().resolveDescriptor(float[].class);
    }

    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaType<T> javaTypeDescriptor) {
        return new PGVectorJdbcLiteralFormatterVector<T>(javaTypeDescriptor, this.getElementJdbcType().getJdbcLiteralFormatter(PGVectorJdbcType.elementJavaType(javaTypeDescriptor)));
    }

    public void appendWriteExpression(String writeExpression, @Nullable Size size, SqlAppender appender, Dialect dialect) {
        appender.append((CharSequence)"cast(");
        appender.append((CharSequence)writeExpression);
        appender.append((CharSequence)" as ");
        appender.append((CharSequence)this.typeName);
        appender.append(')');
    }

    public boolean isWriteExpressionTyped(Dialect dialect) {
        return true;
    }

    public @Nullable String castFromPattern(JdbcMapping sourceMapping, @Nullable Size size) {
        return sourceMapping.getJdbcType().isStringLike() ? "cast(?1 as " + this.typeName + ")" : null;
    }

    public <X> ValueExtractor<X> getExtractor(final JavaType<X> javaTypeDescriptor) {
        return new BasicExtractor<X>(this, javaTypeDescriptor, (JdbcType)this){
            final /* synthetic */ PGVectorJdbcType this$0;
            {
                this.this$0 = this$0;
                super(javaType, jdbcType);
            }

            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap((Object)VectorHelper.parseFloatVector(rs.getString(paramIndex)), options);
            }

            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap((Object)VectorHelper.parseFloatVector(statement.getString(index)), options);
            }

            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap((Object)VectorHelper.parseFloatVector(statement.getString(name)), options);
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        if (!super.equals(that)) return false;
        if (!(that instanceof PGVectorJdbcType)) return false;
        PGVectorJdbcType vectorJdbcType = (PGVectorJdbcType)((Object)that);
        if (this.sqlType != vectorJdbcType.sqlType) return false;
        return true;
    }

    public int hashCode() {
        return this.sqlType + 31 * super.hashCode();
    }
}

