/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector.internal;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.ArrayJdbcType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.vector.SparseFloatVector;
import org.hibernate.vector.internal.PGVectorJdbcLiteralFormatterSparseVector;

public class PGSparseFloatVectorJdbcType
extends ArrayJdbcType {
    public PGSparseFloatVectorJdbcType(JdbcType elementJdbcType) {
        super(elementJdbcType);
    }

    public int getDefaultSqlTypeCode() {
        return 10007;
    }

    public JavaType<?> getRecommendedJavaType(Integer precision, Integer scale, TypeConfiguration typeConfiguration) {
        return typeConfiguration.getJavaTypeRegistry().resolveDescriptor(float[].class);
    }

    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaType<T> javaTypeDescriptor) {
        return new PGVectorJdbcLiteralFormatterSparseVector<T>(javaTypeDescriptor);
    }

    public void appendWriteExpression(String writeExpression, @Nullable Size size, SqlAppender appender, Dialect dialect) {
        appender.append((CharSequence)"cast(");
        appender.append((CharSequence)writeExpression);
        appender.append((CharSequence)" as sparsevec)");
    }

    public boolean isWriteExpressionTyped(Dialect dialect) {
        return true;
    }

    public @Nullable String castFromPattern(JdbcMapping sourceMapping, @Nullable Size size) {
        return sourceMapping.getJdbcType().isStringLike() ? "cast(?1 as sparsevec)" : null;
    }

    public <X> ValueBinder<X> getBinder(JavaType<X> javaTypeDescriptor) {
        return new BasicBinder<X>(javaTypeDescriptor, (JdbcType)this){

            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                st.setString(index, this.getString(value, options));
            }

            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                st.setString(name, this.getString(value, options));
            }

            public Object getBindValue(X value, WrapperOptions options) {
                return this.getString(value, options);
            }

            private String getString(X value, WrapperOptions options) {
                SparseFloatVector vector = (SparseFloatVector)this.getJavaType().unwrap(value, SparseFloatVector.class, options);
                int size = vector.size();
                int[] indices = vector.indices();
                float[] floats = vector.floats();
                StringBuilder sb = new StringBuilder(indices.length * 50);
                int separator = 123;
                for (int i = 0; i < indices.length; ++i) {
                    sb.append((char)separator);
                    sb.append(indices[i] + 1);
                    sb.append(':');
                    sb.append(floats[i]);
                    separator = 44;
                }
                sb.append("}/");
                sb.append(size);
                return sb.toString();
            }
        };
    }

    public <X> ValueExtractor<X> getExtractor(final JavaType<X> javaTypeDescriptor) {
        return new BasicExtractor<X>(this, javaTypeDescriptor, (JdbcType)this){
            final /* synthetic */ PGSparseFloatVectorJdbcType this$0;
            {
                this.this$0 = this$0;
                super(javaType, jdbcType);
            }

            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap((Object)PGSparseFloatVectorJdbcType.parseSparseFloatVector(rs.getString(paramIndex)), options);
            }

            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap((Object)PGSparseFloatVectorJdbcType.parseSparseFloatVector(statement.getString(index)), options);
            }

            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap((Object)PGSparseFloatVectorJdbcType.parseSparseFloatVector(statement.getString(name)), options);
            }
        };
    }

    private static @Nullable SparseFloatVector parseSparseFloatVector(@Nullable String string) {
        if (string == null) {
            return null;
        }
        int slashIndex = string.lastIndexOf(47);
        if (string.charAt(0) != '{' || slashIndex == -1 || string.charAt(slashIndex - 1) != '}') {
            throw new IllegalArgumentException("Invalid sparse vector string: " + string);
        }
        int size = Integer.parseInt(string, slashIndex + 1, string.length(), 10);
        int end = slashIndex - 1;
        int count = PGSparseFloatVectorJdbcType.countValues(string, end);
        int[] indices = new int[count];
        float[] values = new float[count];
        int start = 1;
        int index = 0;
        for (int i = start; i < end; ++i) {
            char c = string.charAt(i);
            if (c == ':') {
                indices[index] = Integer.parseInt(string, start, i, 10) - 1;
                start = i + 1;
                continue;
            }
            if (c != ',') continue;
            values[index++] = Float.parseFloat(string.substring(start, i));
            start = i + 1;
        }
        if (start != end) {
            values[index] = Float.parseFloat(string.substring(start, end));
            assert (count == index + 1);
        }
        return new SparseFloatVector(size, indices, values);
    }

    private static int countValues(String string, int end) {
        int count = 0;
        for (int i = 1; i < end; ++i) {
            if (string.charAt(i) != ':') continue;
            ++count;
        }
        return count;
    }
}

