/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector.internal;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.ArrayJdbcType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.vector.internal.PGVectorJdbcLiteralFormatterBinaryVector;
import org.hibernate.vector.internal.VectorHelper;

public class PGBinaryVectorJdbcType
extends ArrayJdbcType {
    public PGBinaryVectorJdbcType(JdbcType elementJdbcType) {
        super(elementJdbcType);
    }

    public int getDefaultSqlTypeCode() {
        return 10004;
    }

    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaType<T> javaTypeDescriptor) {
        return new PGVectorJdbcLiteralFormatterBinaryVector<T>(javaTypeDescriptor);
    }

    public JavaType<?> getRecommendedJavaType(Integer precision, Integer scale, TypeConfiguration typeConfiguration) {
        return typeConfiguration.getJavaTypeRegistry().resolveDescriptor(byte[].class);
    }

    public @Nullable String castFromPattern(JdbcMapping sourceMapping, @Nullable Size size) {
        return sourceMapping.getJdbcType().isStringLike() ? "cast(?1 as varbit)" : null;
    }

    public <X> ValueBinder<X> getBinder(JavaType<X> javaTypeDescriptor) {
        return new BasicBinder<X>(javaTypeDescriptor, (JdbcType)this){

            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                st.setObject(index, (Object)VectorHelper.toBitString((byte[])this.getJavaType().unwrap(value, byte[].class, options)), 1111);
            }

            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                st.setObject(name, (Object)VectorHelper.toBitString((byte[])this.getJavaType().unwrap(value, byte[].class, options)), 1111);
            }
        };
    }

    public <X> ValueExtractor<X> getExtractor(final JavaType<X> javaTypeDescriptor) {
        return new BasicExtractor<X>(this, javaTypeDescriptor, (JdbcType)this){
            final /* synthetic */ PGBinaryVectorJdbcType this$0;
            {
                this.this$0 = this$0;
                super(javaType, jdbcType);
            }

            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap((Object)VectorHelper.parseBitString(rs.getString(paramIndex)), options);
            }

            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap((Object)VectorHelper.parseBitString(statement.getString(index)), options);
            }

            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap((Object)VectorHelper.parseBitString(statement.getString(name)), options);
            }
        };
    }
}

