/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector.internal;

import org.hibernate.dialect.Dialect;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.spi.BasicJdbcLiteralFormatter;

public class OracleJdbcLiteralFormatterVector<T>
extends BasicJdbcLiteralFormatter<T> {
    private final JdbcLiteralFormatter<Object> elementFormatter;
    private final String vectorParameters;

    public OracleJdbcLiteralFormatterVector(JavaType<T> javaType, JdbcLiteralFormatter<?> elementFormatter, String vectorParameters) {
        super(javaType);
        this.elementFormatter = elementFormatter;
        this.vectorParameters = vectorParameters;
    }

    public void appendJdbcLiteral(SqlAppender appender, T value, Dialect dialect, WrapperOptions wrapperOptions) {
        Object[] objects = (Object[])this.unwrap(value, Object[].class, wrapperOptions);
        appender.append((CharSequence)"to_vector('");
        int separator = 91;
        for (Object o : objects) {
            appender.append((char)separator);
            this.elementFormatter.appendJdbcLiteral(appender, o, dialect, wrapperOptions);
            separator = 44;
        }
        appender.append((CharSequence)"]',");
        appender.append((CharSequence)this.vectorParameters);
        appender.append(')');
    }
}

