/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector.internal;

import org.hibernate.dialect.Dialect;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.spi.BasicJdbcLiteralFormatter;
import org.hibernate.vector.AbstractSparseVector;
import org.hibernate.vector.SparseByteVector;
import org.hibernate.vector.SparseDoubleVector;
import org.hibernate.vector.SparseFloatVector;

public class OracleJdbcLiteralFormatterSparseVector<T>
extends BasicJdbcLiteralFormatter<T> {
    private final String vectorParameters;

    public OracleJdbcLiteralFormatterSparseVector(JavaType<T> javaType, String vectorParameters) {
        super(javaType);
        this.vectorParameters = vectorParameters;
    }

    public void appendJdbcLiteral(SqlAppender appender, T value, Dialect dialect, WrapperOptions wrapperOptions) {
        appender.appendSql("to_vector('");
        AbstractSparseVector sparseVector = (AbstractSparseVector)this.unwrap(value, AbstractSparseVector.class, wrapperOptions);
        appender.appendSql('[');
        appender.appendSql(sparseVector.size());
        appender.appendSql(',');
        int separator = 91;
        for (int index : sparseVector.indices()) {
            appender.appendSql((char)separator);
            appender.appendSql(index);
            separator = 44;
        }
        appender.appendSql("],");
        separator = 91;
        if (sparseVector instanceof SparseFloatVector) {
            SparseFloatVector floatVector = (SparseFloatVector)sparseVector;
            for (float f : floatVector.floats()) {
                appender.appendSql((char)separator);
                appender.appendSql(f);
                separator = 44;
            }
        } else if (sparseVector instanceof SparseDoubleVector) {
            SparseDoubleVector doubleVector = (SparseDoubleVector)sparseVector;
            for (double d : doubleVector.doubles()) {
                appender.appendSql((char)separator);
                appender.appendSql(d);
                separator = 44;
            }
        } else if (sparseVector instanceof SparseByteVector) {
            SparseByteVector byteVector = (SparseByteVector)sparseVector;
            for (byte b : byteVector.bytes()) {
                appender.appendSql((char)separator);
                appender.appendSql((int)b);
                separator = 44;
            }
        } else {
            throw new IllegalArgumentException("Unsupported sparse vector type: " + sparseVector.getClass().getName());
        }
        appender.appendSql("]]',");
        appender.appendSql(this.vectorParameters);
        appender.appendSql(')');
    }
}

