/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector.internal;

import java.util.Arrays;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.vector.internal.AbstractOracleVectorJdbcType;
import org.hibernate.vector.internal.VectorHelper;

public class OracleDoubleVectorJdbcType
extends AbstractOracleVectorJdbcType {
    public OracleDoubleVectorJdbcType(JdbcType elementJdbcType, boolean isVectorSupported) {
        super(elementJdbcType, isVectorSupported);
    }

    @Override
    public String getVectorParameters() {
        return "*,float64";
    }

    public String getFriendlyName() {
        return "VECTOR_FLOAT64";
    }

    public int getDefaultSqlTypeCode() {
        return 10003;
    }

    protected double[] getVectorArray(String string) {
        return VectorHelper.parseDoubleVector(string);
    }

    @Override
    protected <T> String getStringVector(T vector, JavaType<T> javaTypeDescriptor, WrapperOptions options) {
        return Arrays.toString((double[])javaTypeDescriptor.unwrap(vector, double[].class, options));
    }

    @Override
    protected Class<?> getNativeJavaType() {
        return double[].class;
    }

    @Override
    protected int getNativeTypeCode() {
        return -108;
    }
}

