/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector.internal;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.ArrayJdbcType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.vector.internal.MariaDBJdbcLiteralFormatterVector;

public class MariaDBVectorJdbcType
extends ArrayJdbcType {
    private final int sqlType;

    public MariaDBVectorJdbcType(JdbcType elementJdbcType, int sqlType) {
        super(elementJdbcType);
        this.sqlType = sqlType;
    }

    public int getDefaultSqlTypeCode() {
        return this.sqlType;
    }

    public JavaType<?> getRecommendedJavaType(Integer precision, Integer scale, TypeConfiguration typeConfiguration) {
        return typeConfiguration.getJavaTypeRegistry().resolveDescriptor(float[].class);
    }

    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaType<T> javaTypeDescriptor) {
        return new MariaDBJdbcLiteralFormatterVector<T>(javaTypeDescriptor, this.getElementJdbcType().getJdbcLiteralFormatter(MariaDBVectorJdbcType.elementJavaType(javaTypeDescriptor)));
    }

    public void appendWriteExpression(String writeExpression, @Nullable Size size, SqlAppender appender, Dialect dialect) {
        appender.append((CharSequence)writeExpression);
    }

    public @Nullable String castFromPattern(JdbcMapping sourceMapping, @Nullable Size size) {
        return sourceMapping.getJdbcType().isStringLike() ? "vec_fromtext(?1)" : null;
    }

    public @Nullable String castToPattern(JdbcMapping targetJdbcMapping, @Nullable Size size) {
        return targetJdbcMapping.getJdbcType().isStringLike() ? "vec_totext(?1)" : null;
    }

    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaTypeDescriptor) {
        return new BasicExtractor<X>(javaTypeDescriptor, (JdbcType)this){

            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap((Object)rs.getObject(paramIndex, float[].class), options);
            }

            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap((Object)statement.getObject(index, float[].class), options);
            }

            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap((Object)statement.getObject(name, float[].class), options);
            }
        };
    }

    public <X> ValueBinder<X> getBinder(JavaType<X> javaTypeDescriptor) {
        return new BasicBinder<X>(javaTypeDescriptor, (JdbcType)this){

            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                st.setObject(index, this.getBindValue(value, options));
            }

            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                st.setObject(name, this.getBindValue(value, options), 2003);
            }

            public Object getBindValue(X value, WrapperOptions options) {
                return this.getJavaType().unwrap(value, float[].class, options);
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        if (!super.equals(that)) return false;
        if (!(that instanceof MariaDBVectorJdbcType)) return false;
        MariaDBVectorJdbcType vectorJdbcType = (MariaDBVectorJdbcType)((Object)that);
        if (this.sqlType != vectorJdbcType.sqlType) return false;
        return true;
    }

    public int hashCode() {
        return this.sqlType + 31 * super.hashCode();
    }
}

