/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector.internal;

import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.FunctionContributor;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.BasicType;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.vector.internal.VectorFunctionFactory;

public class DB2VectorFunctionContributor
implements FunctionContributor {
    public void contributeFunctions(FunctionContributions functionContributions) {
        DB2Dialect db2Dialect;
        Dialect dialect = functionContributions.getDialect();
        if (dialect instanceof DB2Dialect && (db2Dialect = (DB2Dialect)dialect).getDB2Version().isSameOrAfter(12, 1, 2)) {
            VectorFunctionFactory vectorFunctionFactory = new VectorFunctionFactory(functionContributions);
            vectorFunctionFactory.cosineDistance("vector_distance(?1,?2,COSINE)");
            vectorFunctionFactory.euclideanDistance("vector_distance(?1,?2,EUCLIDEAN)");
            vectorFunctionFactory.euclideanSquaredDistance("vector_distance(?1,?2,EUCLIDEAN_SQUARED)");
            vectorFunctionFactory.l1Distance("vector_distance(?1,?2,MANHATTAN)");
            vectorFunctionFactory.hammingDistance("vector_distance(?1,?2,HAMMING)");
            vectorFunctionFactory.innerProduct("vector_distance(?1,?2,DOT)*-1");
            vectorFunctionFactory.negativeInnerProduct("vector_distance(?1,?2,DOT)");
            TypeConfiguration typeConfiguration = functionContributions.getTypeConfiguration();
            BasicType integerType = typeConfiguration.getBasicTypeForJavaType(Integer.class);
            BasicType doubleType = typeConfiguration.getBasicTypeForJavaType(Double.class);
            vectorFunctionFactory.registerNamedVectorFunction("vector_dimension_count", integerType, 1);
            functionContributions.getFunctionRegistry().registerAlternateKey("vector_dims", "vector_dimension_count");
            vectorFunctionFactory.registerPatternVectorFunction("vector_norm", "vector_norm(?1,EUCLIDEAN)", doubleType, 1);
        }
    }

    public int ordinal() {
        return 200;
    }
}

