/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector.internal;

import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.vector.internal.AbstractDB2VectorJdbcType;
import org.hibernate.vector.internal.VectorHelper;

public class DB2FloatVectorJdbcType
extends AbstractDB2VectorJdbcType {
    public DB2FloatVectorJdbcType(JdbcType elementJdbcType) {
        super(elementJdbcType);
    }

    @Override
    public String getVectorParameters(@Nullable Size size) {
        assert (size != null);
        return size.getArrayLength() + ",float32";
    }

    public String getFriendlyName() {
        return "VECTOR_FLOAT32";
    }

    public int getDefaultSqlTypeCode() {
        return 10002;
    }

    protected float[] getVectorArray(String string) {
        return VectorHelper.parseFloatVector(string);
    }

    @Override
    protected <T> String getStringVector(T vector, JavaType<T> javaTypeDescriptor, WrapperOptions options) {
        return Arrays.toString((float[])javaTypeDescriptor.unwrap(vector, float[].class, options));
    }
}

