/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector.internal;

import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.vector.internal.AbstractDB2VectorJdbcType;
import org.hibernate.vector.internal.VectorHelper;

public class DB2ByteVectorJdbcType
extends AbstractDB2VectorJdbcType {
    public DB2ByteVectorJdbcType(JdbcType elementJdbcType) {
        super(elementJdbcType);
    }

    @Override
    public String getVectorParameters(@Nullable Size size) {
        assert (size != null);
        return size.getArrayLength() + ",int8";
    }

    public String getFriendlyName() {
        return "VECTOR_INT8";
    }

    public int getDefaultSqlTypeCode() {
        return 10001;
    }

    protected byte[] getVectorArray(String string) {
        return VectorHelper.parseByteVector(string);
    }

    @Override
    protected <T> String getStringVector(T vector, JavaType<T> javaTypeDescriptor, WrapperOptions options) {
        return Arrays.toString((byte[])javaTypeDescriptor.unwrap(vector, byte[].class, options));
    }
}

