/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector.internal;

import org.hibernate.boot.model.TypeContributions;
import org.hibernate.boot.model.TypeContributor;
import org.hibernate.dialect.CockroachDialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.BasicArrayType;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.descriptor.sql.DdlType;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.vector.internal.PGVectorJdbcType;
import org.hibernate.vector.internal.VectorDdlType;

public class CockroachTypeContributor
implements TypeContributor {
    public void contribute(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        Dialect dialect = ((JdbcServices)serviceRegistry.requireService(JdbcServices.class)).getDialect();
        if (dialect instanceof CockroachDialect && dialect.getVersion().isSameOrAfter(24, 2)) {
            TypeConfiguration typeConfiguration = typeContributions.getTypeConfiguration();
            JavaTypeRegistry javaTypeRegistry = typeConfiguration.getJavaTypeRegistry();
            JdbcTypeRegistry jdbcTypeRegistry = typeConfiguration.getJdbcTypeRegistry();
            BasicTypeRegistry basicTypeRegistry = typeConfiguration.getBasicTypeRegistry();
            BasicType floatBasicType = basicTypeRegistry.resolve(StandardBasicTypes.FLOAT);
            PGVectorJdbcType genericVectorJdbcType = new PGVectorJdbcType(jdbcTypeRegistry.getDescriptor(6), 10000, "vector");
            jdbcTypeRegistry.addDescriptor(10000, (JdbcType)genericVectorJdbcType);
            PGVectorJdbcType floatVectorJdbcType = new PGVectorJdbcType(jdbcTypeRegistry.getDescriptor(6), 10002, "vector");
            jdbcTypeRegistry.addDescriptor(10002, (JdbcType)floatVectorJdbcType);
            basicTypeRegistry.register((BasicType)new BasicArrayType(floatBasicType, (JdbcType)genericVectorJdbcType, javaTypeRegistry.resolveDescriptor(float[].class)), StandardBasicTypes.VECTOR.getName());
            basicTypeRegistry.register((BasicType)new BasicArrayType(basicTypeRegistry.resolve(StandardBasicTypes.FLOAT), (JdbcType)floatVectorJdbcType, javaTypeRegistry.resolveDescriptor(float[].class)), StandardBasicTypes.VECTOR_FLOAT32.getName());
            typeConfiguration.getDdlTypeRegistry().addDescriptor((DdlType)new VectorDdlType(10000, "vector($l)", "vector", dialect));
            typeConfiguration.getDdlTypeRegistry().addDescriptor((DdlType)new VectorDdlType(10002, "vector($l)", "vector", dialect));
        }
    }
}

