/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector.internal;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.ArrayJdbcType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.vector.internal.OracleJdbcLiteralFormatterVector;

public abstract class AbstractOracleVectorJdbcType
extends ArrayJdbcType {
    final boolean isVectorSupported;

    public AbstractOracleVectorJdbcType(JdbcType elementJdbcType, boolean isVectorSupported) {
        super(elementJdbcType);
        this.isVectorSupported = isVectorSupported;
    }

    public @Nullable String castToPattern(JdbcMapping targetJdbcMapping, @Nullable Size size) {
        return targetJdbcMapping.getJdbcType().isStringLike() ? "from_vector(?1 returning ?2)" : null;
    }

    public @Nullable String castFromPattern(JdbcMapping sourceMapping, @Nullable Size size) {
        return sourceMapping.getJdbcType().isStringLike() ? "to_vector(?1," + this.getVectorParameters() + ")" : null;
    }

    public void appendWriteExpression(String writeExpression, @Nullable Size size, SqlAppender appender, Dialect dialect) {
        if (this.isVectorSupported) {
            appender.append((CharSequence)writeExpression);
        } else {
            appender.append((CharSequence)"to_vector(");
            appender.append((CharSequence)writeExpression);
            appender.append(',');
            appender.append((CharSequence)this.getVectorParameters());
            appender.append(')');
        }
    }

    public boolean isWriteExpressionTyped(Dialect dialect) {
        return !this.isVectorSupported;
    }

    public abstract String getVectorParameters();

    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaType<T> javaTypeDescriptor) {
        return new OracleJdbcLiteralFormatterVector<T>(javaTypeDescriptor, this.getElementJdbcType().getJdbcLiteralFormatter(AbstractOracleVectorJdbcType.elementJavaType(javaTypeDescriptor)), this.getVectorParameters().replace(",sparse", ""));
    }

    public String toString() {
        return "OracleVectorTypeDescriptor";
    }

    public <X> ValueBinder<X> getBinder(JavaType<X> javaTypeDescriptor) {
        return new BasicBinder<X>(javaTypeDescriptor, (JdbcType)this){

            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                if (AbstractOracleVectorJdbcType.this.isVectorSupported) {
                    st.setObject(index, value, ((AbstractOracleVectorJdbcType)this.getJdbcType()).getNativeTypeCode());
                } else {
                    st.setString(index, ((AbstractOracleVectorJdbcType)this.getJdbcType()).getStringVector(value, this.getJavaType(), options));
                }
            }

            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                if (AbstractOracleVectorJdbcType.this.isVectorSupported) {
                    st.setObject(name, value, ((AbstractOracleVectorJdbcType)this.getJdbcType()).getNativeTypeCode());
                } else {
                    st.setString(name, ((AbstractOracleVectorJdbcType)this.getJdbcType()).getStringVector(value, this.getJavaType(), options));
                }
            }
        };
    }

    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaTypeDescriptor) {
        return new BasicExtractor<X>(javaTypeDescriptor, (JdbcType)this){

            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                if (AbstractOracleVectorJdbcType.this.isVectorSupported) {
                    return this.getJavaType().wrap(rs.getObject(paramIndex, ((AbstractOracleVectorJdbcType)this.getJdbcType()).getNativeJavaType()), options);
                }
                return this.getJavaType().wrap(((AbstractOracleVectorJdbcType)this.getJdbcType()).getVectorArray(rs.getString(paramIndex)), options);
            }

            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                if (AbstractOracleVectorJdbcType.this.isVectorSupported) {
                    return this.getJavaType().wrap(statement.getObject(index, ((AbstractOracleVectorJdbcType)this.getJdbcType()).getNativeJavaType()), options);
                }
                return this.getJavaType().wrap(((AbstractOracleVectorJdbcType)this.getJdbcType()).getVectorArray(statement.getString(index)), options);
            }

            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                if (AbstractOracleVectorJdbcType.this.isVectorSupported) {
                    return this.getJavaType().wrap(statement.getObject(name, ((AbstractOracleVectorJdbcType)this.getJdbcType()).getNativeJavaType()), options);
                }
                return this.getJavaType().wrap(((AbstractOracleVectorJdbcType)this.getJdbcType()).getVectorArray(statement.getString(name)), options);
            }
        };
    }

    protected abstract Object getVectorArray(String var1);

    protected abstract <T> String getStringVector(T var1, JavaType<T> var2, WrapperOptions var3);

    protected abstract Class<?> getNativeJavaType();

    protected abstract int getNativeTypeCode();
}

