/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector.internal;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.vector.AbstractSparseVector;
import org.hibernate.vector.internal.AbstractOracleVectorJdbcType;
import org.hibernate.vector.internal.OracleJdbcLiteralFormatterSparseVector;

public abstract class AbstractOracleSparseVectorJdbcType
extends AbstractOracleVectorJdbcType {
    public AbstractOracleSparseVectorJdbcType(JdbcType elementJdbcType, boolean isVectorSupported) {
        super(elementJdbcType, isVectorSupported);
    }

    @Override
    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaType<T> javaTypeDescriptor) {
        return new OracleJdbcLiteralFormatterSparseVector<T>(javaTypeDescriptor, this.getVectorParameters());
    }

    @Override
    public <X> ValueBinder<X> getBinder(JavaType<X> javaTypeDescriptor) {
        return new BasicBinder<X>(javaTypeDescriptor, (JdbcType)this){

            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                if (AbstractOracleSparseVectorJdbcType.this.isVectorSupported) {
                    st.setObject(index, this.getBindValue(value, options));
                } else {
                    st.setString(index, this.stringVector(value, options));
                }
            }

            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                if (AbstractOracleSparseVectorJdbcType.this.isVectorSupported) {
                    st.setObject(name, this.getBindValue(value, options));
                } else {
                    st.setString(name, this.stringVector(value, options));
                }
            }

            private String stringVector(X value, WrapperOptions options) {
                return ((AbstractOracleSparseVectorJdbcType)this.getJdbcType()).getStringVector(value, this.getJavaType(), options);
            }

            public Object getBindValue(X value, WrapperOptions options) {
                return ((AbstractOracleSparseVectorJdbcType)this.getJdbcType()).getBindValue(this.getJavaType(), value, options);
            }
        };
    }

    protected abstract <X> Object getBindValue(JavaType<X> var1, X var2, WrapperOptions var3);

    @Override
    protected <T> String getStringVector(T vector, JavaType<T> javaTypeDescriptor, WrapperOptions options) {
        return ((AbstractSparseVector)javaTypeDescriptor.unwrap(vector, AbstractSparseVector.class, options)).toString();
    }

    @Override
    protected Class<?> getNativeJavaType() {
        return Object.class;
    }

    @Override
    protected int getNativeTypeCode() {
        return 1111;
    }
}

