/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector;

import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.FunctionContributor;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.vector.VectorFunctionFactory;

public class OracleVectorFunctionContributor
implements FunctionContributor {
    public void contributeFunctions(FunctionContributions functionContributions) {
        Dialect dialect = functionContributions.getDialect();
        if (dialect instanceof OracleDialect) {
            VectorFunctionFactory vectorFunctionFactory = new VectorFunctionFactory(functionContributions);
            vectorFunctionFactory.cosineDistance("vector_distance(?1,?2,COSINE)");
            vectorFunctionFactory.euclideanDistance("vector_distance(?1,?2,EUCLIDEAN)");
            vectorFunctionFactory.l1Distance("vector_distance(?1,?2,MANHATTAN)");
            vectorFunctionFactory.hammingDistance("vector_distance(?1,?2,HAMMING)");
            vectorFunctionFactory.innerProduct("vector_distance(?1,?2,DOT)*-1");
            vectorFunctionFactory.negativeInnerProduct("vector_distance(?1,?2,DOT)");
            vectorFunctionFactory.vectorDimensions();
            vectorFunctionFactory.vectorNorm();
        }
    }

    public int ordinal() {
        return 200;
    }
}

